/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.web.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonatype.nexus.web.ErrorStatusException;
import org.sonatype.nexus.web.TemplateRenderer;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class ErrorPageFilter
extends ComponentSupport
implements Filter {
    private final TemplateRenderer templateRenderer;

    @Inject
    public ErrorPageFilter(TemplateRenderer templateRenderer) {
        this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer);
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        try {
            chain.doFilter(req, (ServletResponse)response);
        }
        catch (ErrorStatusException e) {
            this.templateRenderer.renderErrorPage(request, response, e.getResponseCode(), e.getReasonPhrase(), ErrorPageFilter.messageOf((Throwable)((Object)e)), e.getCause());
        }
        catch (IOException e) {
            response.setStatus(500);
        }
        catch (Exception e) {
            this.log.warn("Unexpected exception", (Throwable)e);
            this.templateRenderer.renderErrorPage(request, response, 500, null, ErrorPageFilter.messageOf(e), e);
        }
    }

    private static String messageOf(Throwable cause) {
        String message = cause.getMessage();
        if (message == null) {
            return cause.toString();
        }
        return message;
    }
}

