/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.web.internal;

import java.util.Collection;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.web.servlet.AdviceFilter;

@Named
@Singleton
public class CookieFilter
extends AdviceFilter {
    private static final String SECURE_FLAG = "; Secure";

    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        this.filterCookies(request, response);
        return true;
    }

    protected void filterCookies(ServletRequest request, ServletResponse response) {
        if (request.isSecure() && response instanceof HttpServletResponse) {
            this.secureCookies((HttpServletResponse)response);
        }
    }

    private void secureCookies(HttpServletResponse response) {
        Collection cookies = response.getHeaders("Set-Cookie");
        boolean mustAdd = false;
        for (String cookie : cookies) {
            String cookieVal;
            String string = cookieVal = cookie.lastIndexOf(SECURE_FLAG) == -1 ? cookie + SECURE_FLAG : cookie;
            if (mustAdd) {
                response.addHeader("Set-Cookie", cookieVal);
            } else {
                response.setHeader("Set-Cookie", cookieVal);
            }
            mustAdd = true;
        }
    }
}

