/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.web.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import eu.bitwalker.useragentutils.UserAgent;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletRequest;
import org.apache.shiro.web.util.WebUtils;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class BrowserDetector
extends ComponentSupport {
    @VisibleForTesting
    static final String USER_AGENT = "User-Agent";
    private final boolean disable;
    private final Set<String> excludedUserAgents = Sets.newHashSet();
    private final Cache<String, UserAgent> cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(2L, TimeUnit.HOURS).build();

    @Inject
    public BrowserDetector(@Named(value="${nexus.browserdetector.disable:-false}") boolean disable, @Named(value="${nexus.browserdetector.excludedUserAgents}") @Nullable String excludedUserAgents) {
        this.disable = disable;
        if (disable) {
            this.log.info("Browser detector disabled");
        }
        if (excludedUserAgents != null) {
            for (String userAgent : Splitter.on((Pattern)Pattern.compile("\r?\n")).trimResults().split((CharSequence)excludedUserAgents)) {
                if (userAgent.length() <= 0) continue;
                this.log.info("Browser detector excluding User-Agent: {}", (Object)userAgent);
                this.excludedUserAgents.add(userAgent);
            }
        }
    }

    public boolean isBrowserInitiated(ServletRequest request) {
        Preconditions.checkNotNull((Object)request);
        if (this.disable) {
            return false;
        }
        String userAgentString = WebUtils.toHttp((ServletRequest)request).getHeader(USER_AGENT);
        if (this.excludedUserAgents.contains(userAgentString)) {
            return false;
        }
        UserAgent userAgent = this.parseUserAgent(userAgentString);
        if (userAgent != null) {
            switch (userAgent.getBrowser().getBrowserType()) {
                case WEB_BROWSER: 
                case MOBILE_BROWSER: 
                case TEXT_BROWSER: {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private UserAgent parseUserAgent(String headerValue) {
        if (headerValue == null) {
            return null;
        }
        UserAgent userAgent = (UserAgent)this.cache.getIfPresent((Object)headerValue);
        if (userAgent == null) {
            userAgent = UserAgent.parseUserAgentString((String)headerValue);
            this.cache.put((Object)headerValue, (Object)userAgent);
        }
        return userAgent;
    }
}

