/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.web.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.sonatype.nexus.configuration.application.GlobalRestApiSettings;
import org.sonatype.nexus.web.BaseUrlHolder;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class BaseUrlDetector
extends ComponentSupport {
    private final GlobalRestApiSettings settings;
    private final Provider<HttpServletRequest> requestProvider;

    @Inject
    public BaseUrlDetector(GlobalRestApiSettings settings, Provider<HttpServletRequest> requestProvider) {
        this.settings = (GlobalRestApiSettings)Preconditions.checkNotNull((Object)settings);
        this.requestProvider = (Provider)Preconditions.checkNotNull(requestProvider);
    }

    @Nullable
    private HttpServletRequest httpRequest() {
        try {
            return (HttpServletRequest)this.requestProvider.get();
        }
        catch (Exception e) {
            this.log.trace("Unable to resolve HTTP servlet-request", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public String detect() {
        if (this.settings.isEnabled() && this.settings.isForceBaseUrl() && !Strings.isNullOrEmpty((String)this.settings.getBaseUrl())) {
            return this.settings.getBaseUrl();
        }
        HttpServletRequest request = this.httpRequest();
        if (request != null) {
            String servletPath;
            StringBuilder buff = new StringBuilder();
            String requestUrl = request.getRequestURL().toString();
            String pathInfo = request.getPathInfo();
            if (!Strings.isNullOrEmpty((String)pathInfo)) {
                requestUrl = requestUrl.substring(0, requestUrl.length() - pathInfo.length());
            }
            if (!Strings.isNullOrEmpty((String)(servletPath = request.getServletPath()))) {
                requestUrl = requestUrl.substring(0, requestUrl.length() - servletPath.length());
            }
            buff.append(requestUrl);
            return buff.toString();
        }
        if (!Strings.isNullOrEmpty((String)this.settings.getBaseUrl())) {
            return this.settings.getBaseUrl();
        }
        return null;
    }

    public void set() {
        String url = this.detect();
        if (url != null) {
            BaseUrlHolder.set(url);
        }
    }
}

