/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.web;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.nexus.util.io.StreamSupport;

@Named
@Singleton
public class WebUtils {
    private static final int BUFFER_SIZE = SystemPropertiesHelper.getInteger(WebUtils.class.getName() + ".BUFFER_SIZE", -1);
    private final String serverString;

    @Inject
    public WebUtils(ApplicationStatusSource applicationStatusSource) {
        this.serverString = "Nexus/" + ((ApplicationStatusSource)Preconditions.checkNotNull((Object)applicationStatusSource)).getSystemStatus().getVersion();
    }

    public void sendTemporaryRedirect(HttpServletResponse response, String url) throws IOException {
        response.setStatus(302);
        response.addHeader("Location", url);
        response.flushBuffer();
    }

    public void equipResponseWithStandardHeaders(HttpServletResponse response) {
        response.setHeader("Server", this.serverString);
        response.setHeader("X-Frame-Options", "SAMEORIGIN");
        response.setHeader("X-Content-Type-Options", "nosniff");
    }

    public void addNoCacheResponseHeaders(HttpServletResponse response) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
        response.setHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Expires", "0");
    }

    public void sendContent(InputStream input, HttpServletResponse response) throws IOException {
        int bufferSize = BUFFER_SIZE;
        if (bufferSize < 1) {
            bufferSize = response.getBufferSize();
            if (bufferSize < 1) {
                bufferSize = 8192;
                response.setBufferSize(bufferSize);
            }
        } else {
            response.setBufferSize(bufferSize);
        }
        try (InputStream from = input;
             ServletOutputStream to = response.getOutputStream();){
            StreamSupport.copy(from, (OutputStream)to, bufferSize);
            response.flushBuffer();
        }
    }
}

