/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.web;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class RemoteIPFinder {
    public static final String FORWARD_HEADER = "X-Forwarded-For";

    public static String findIP(HttpServletRequest request) {
        String forwardedIP = RemoteIPFinder.getFirstForwardedIp(request.getHeader(FORWARD_HEADER));
        if (forwardedIP != null) {
            return forwardedIP;
        }
        return request.getRemoteAddr();
    }

    public static String getFirstForwardedIp(String forwardedFor) {
        if (!StringUtils.isEmpty((String)forwardedFor)) {
            return RemoteIPFinder.resolveIp(forwardedFor.split("\\s*,\\s*"));
        }
        return null;
    }

    public static String resolveIp(String[] ipAddresses) {
        for (String ip : ipAddresses) {
            InetAddress ipAdd;
            try {
                ipAdd = InetAddress.getByName(ip);
            }
            catch (UnknownHostException e) {
                continue;
            }
            if (!(ipAdd instanceof Inet4Address) && !(ipAdd instanceof Inet6Address)) continue;
            return ip;
        }
        return null;
    }
}

