/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.web;

import com.google.common.base.Preconditions;
import javax.servlet.ServletException;

public class ErrorStatusException
extends ServletException {
    private final int responseCode;
    private final String reasonPhrase;

    public ErrorStatusException(int responseCode, String reasonPhrase, String errorMessage, Exception cause) {
        super(errorMessage, (Throwable)cause);
        Preconditions.checkArgument((responseCode >= 400 ? 1 : 0) != 0, (String)"Not an error-status code: %s", (Object[])new Object[]{responseCode});
        this.responseCode = responseCode;
        this.reasonPhrase = reasonPhrase;
    }

    public ErrorStatusException(int responseCode, String reasonPhrase, String errorMessage) {
        this(responseCode, reasonPhrase, errorMessage, null);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }
}

