/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.web;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BaseUrlHolder {
    private static final Logger log = LoggerFactory.getLogger(BaseUrlHolder.class);
    private static final InheritableThreadLocal<String> value = new InheritableThreadLocal();

    public static void set(String url) {
        Preconditions.checkNotNull((Object)url);
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        log.trace("Set: {}", (Object)url);
        value.set(url);
    }

    public static String get() {
        String url = (String)value.get();
        Preconditions.checkState((url != null ? 1 : 0) != 0, (Object)"Base URL not set");
        return url;
    }

    public static void unset() {
        log.trace("Unset");
        value.remove();
    }

    public static boolean isSet() {
        return value.get() != null;
    }
}

