/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.velocity;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.velocity.app.VelocityEngine;
import org.sonatype.nexus.velocity.Slf4jLogChute;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class VelocityEngineProvider
extends ComponentSupport
implements Provider<VelocityEngine> {
    private final VelocityEngine sharedVelocityEngine = this.createEngine();

    @Inject
    public VelocityEngineProvider() {
    }

    public VelocityEngine get() {
        return this.sharedVelocityEngine;
    }

    private VelocityEngine createEngine() {
        this.log.info("Creating Nexus VelocityEngine");
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.setProperty("runtime.log.logsystem", (Object)new Slf4jLogChute());
        velocityEngine.setProperty("velocimacro.library", (Object)"");
        velocityEngine.setProperty("resource.loader", (Object)"class");
        velocityEngine.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        velocityEngine.setProperty("runtime.references.strict", (Object)"true");
        velocityEngine.setProperty("resource.loader", (Object)"class");
        velocityEngine.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        velocityEngine.setProperty("class.resource.loader.cache", (Object)"true");
        velocityEngine.setProperty("class.resource.loader.modificationCheckInterval", (Object)"0");
        velocityEngine.setProperty("runtime.references.strict", (Object)"false");
        velocityEngine.setProperty("velocimacro.permissions.allow.inline.local.scope", (Object)"true");
        try {
            velocityEngine.init();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot initialize VelocityEngine", e);
        }
        return velocityEngine;
    }
}

