/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.util.io;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.sonatype.nexus.util.SystemPropertiesHelper;

public final class StreamSupport {
    public static final int BUFFER_SIZE = SystemPropertiesHelper.getInteger(StreamSupport.class.getName() + ".BUFFER_SIZE", 8192);

    private StreamSupport() {
    }

    public static long copy(InputStream from, OutputStream to, int bufferSize) throws IOException {
        int r;
        Preconditions.checkNotNull((Object)from);
        Preconditions.checkNotNull((Object)to);
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0);
        byte[] buf = new byte[bufferSize];
        long count = 0L;
        while ((r = from.read(buf)) != -1) {
            count += (long)r;
            to.write(buf, 0, r);
        }
        return count;
    }
}

