/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.util.file;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.sonatype.nexus.util.file.DirSupport;
import org.sonatype.sisu.goodies.common.SimpleFormat;

public final class FileSupport {
    public static final Charset DEFAULT_CHARSET = Charsets.UTF_8;

    private FileSupport() {
    }

    public static void copy(InputStream from, Path to) throws IOException {
        FileSupport.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copy(InputStream from, Path to, CopyOption ... options) throws IOException {
        Preconditions.checkNotNull((Object)from);
        Preconditions.checkNotNull((Object)to);
        DirSupport.mkdir(to.getParent());
        try (InputStream is = from;){
            Files.copy(is, to, options);
        }
        catch (IOException e) {
            Files.delete(to);
        }
    }

    public static String readFile(Path file) throws IOException {
        return FileSupport.readFile(file, DEFAULT_CHARSET);
    }

    public static String readFile(Path file, Charset charset) throws IOException {
        FileSupport.validateFile(file);
        Preconditions.checkNotNull((Object)charset);
        try (BufferedReader reader = Files.newBufferedReader(file, charset);){
            StringBuilder result = new StringBuilder();
            String line1 = reader.readLine();
            String line2 = reader.readLine();
            while (line1 != null) {
                result.append(line1);
                if (line2 != null) {
                    result.append("\n");
                }
                line1 = line2;
                line2 = reader.readLine();
            }
            String string = result.toString();
            return string;
        }
    }

    public static void writeFile(Path file, String payload) throws IOException {
        FileSupport.writeFile(file, DEFAULT_CHARSET, payload);
    }

    public static void writeFile(Path file, Charset charset, String payload) throws IOException {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)charset);
        Preconditions.checkNotNull((Object)payload);
        DirSupport.mkdir(file.getParent());
        try (BufferedWriter writer = Files.newBufferedWriter(file, charset, new OpenOption[0]);){
            writer.write(payload);
            writer.flush();
        }
    }

    private static void validateFile(Path ... paths) {
        for (Path path : paths) {
            Preconditions.checkNotNull((Object)path, (Object)"Path must be non-null");
            Preconditions.checkArgument((boolean)Files.isRegularFile(path, new LinkOption[0]), (Object)SimpleFormat.template((String)"%s is not a regular file", (Object[])new Object[]{path}));
        }
    }
}

