/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.util;

import com.google.common.base.Throwables;
import java.io.UnsupportedEncodingException;
import org.codehaus.plexus.util.Base64;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.sonatype.nexus.util.DigesterUtils;
import org.sonatype.sisu.goodies.common.TestAccessible;

public class Tokens {
    @NonNls
    public static final String UTF_8 = "UTF8";
    @NonNls
    public static final String NL = System.getProperty("line.separator");
    @TestAccessible
    @NonNls
    static final String MASK = "****";

    public static String encode(String input, char separator, int delay) {
        StringBuilder buff = new StringBuilder();
        int i = 0;
        for (char c : input.toCharArray()) {
            if (i != 0 && i % delay == 0) {
                buff.append(separator);
            }
            buff.append(c);
            ++i;
        }
        return buff.toString();
    }

    public static String string(byte[] bytes) {
        try {
            return new String(bytes, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static byte[] bytes(String string) {
        try {
            return string.getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static char[] encodeHex(byte[] bytes) {
        return DigesterUtils.encodeHex(bytes);
    }

    public static String encodeHexString(byte[] bytes) {
        return new String(Tokens.encodeHex(bytes));
    }

    public static byte[] encodeBase64(byte[] bytes) {
        return Base64.encodeBase64((byte[])bytes);
    }

    public static String encodeBase64String(byte[] bytes) {
        return Tokens.string(Tokens.encodeBase64(bytes));
    }

    public static byte[] decodeBase64(byte[] bytes) {
        return Base64.decodeBase64((byte[])bytes);
    }

    public static String decodeBase64String(byte[] bytes) {
        return Tokens.string(Base64.decodeBase64((byte[])bytes));
    }

    public static String decodeBase64String(String str) {
        return Tokens.string(Base64.decodeBase64((byte[])Tokens.bytes(str)));
    }

    public static String mask(@Nullable String password) {
        if (password != null) {
            return MASK;
        }
        return null;
    }

    public static boolean isEmpty(@Nullable String value) {
        return value == null || value.trim().isEmpty();
    }
}

