/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.util;

public class SystemPropertiesHelper {
    public static final int getInteger(String key, int defaultValue) {
        String value = System.getProperty(key);
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static final long getLong(String key, long defaultValue) {
        String value = System.getProperty(key);
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static final boolean getBoolean(String key, boolean defaultValue) {
        String value = System.getProperty(key);
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public static final String getString(String key, String defaultValue) {
        return System.getProperty(key, defaultValue);
    }
}

