/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.util;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.codehaus.plexus.util.StringUtils;

public class PathUtils {
    public static final String PATH_SEPARATOR = "/";
    public static final int PATH_SEPARATOR_LENGTH = "/".length();

    public static int depthOf(String path) {
        return PathUtils.elementsOf(path).size();
    }

    public static List<String> elementsOf(String path) {
        String[] elems;
        ArrayList result = Lists.newArrayList();
        for (String elem : elems = path.split(PATH_SEPARATOR)) {
            if (Strings.isNullOrEmpty((String)elem)) continue;
            result.add(elem);
        }
        return result;
    }

    public static String pathFrom(List<String> elements) {
        return PathUtils.pathFrom(elements, elements.size());
    }

    public static String pathFrom(List<String> elements, Function<String, String> f) {
        return PathUtils.pathFrom(elements, elements.size(), f);
    }

    public static String pathFrom(List<String> elements, int maxElementsToUse) {
        return PathUtils.pathFrom(elements, maxElementsToUse, new Ident());
    }

    public static String pathFrom(List<String> elements, int maxElementsToUse, Function<String, String> f) {
        StringBuilder sb = new StringBuilder(PATH_SEPARATOR);
        int elementsUsed = 0;
        Iterator<String> elementsIterator = elements.iterator();
        while (elementsIterator.hasNext()) {
            sb.append((String)f.apply((Object)elementsIterator.next()));
            if (++elementsUsed == maxElementsToUse) break;
            if (!elementsIterator.hasNext()) continue;
            sb.append(PATH_SEPARATOR);
        }
        return sb.toString();
    }

    public static String concatPaths(String ... p) {
        StringBuilder result = new StringBuilder();
        for (String path : p) {
            if (StringUtils.isEmpty((String)path)) continue;
            if (!path.startsWith(PATH_SEPARATOR)) {
                result.append(PATH_SEPARATOR);
            }
            result.append(path.endsWith(PATH_SEPARATOR) ? path.substring(0, path.length() - PATH_SEPARATOR_LENGTH) : path);
        }
        return result.toString();
    }

    public static String cleanUpTrailingSlash(String path) {
        if (StringUtils.isEmpty((String)path)) {
            path = PATH_SEPARATOR;
        }
        if (path.length() > 1 && path.endsWith(PATH_SEPARATOR)) {
            path = path.substring(0, path.length() - PATH_SEPARATOR_LENGTH);
        }
        return path;
    }

    public static String getParentPath(String path) {
        if (PATH_SEPARATOR.equals(path)) {
            return path;
        }
        int lastSepratorPos = path.lastIndexOf(PATH_SEPARATOR);
        if (lastSepratorPos == 0) {
            return PATH_SEPARATOR;
        }
        return path.substring(0, lastSepratorPos);
    }

    public static int getPathDepth(String path) {
        if (PATH_SEPARATOR.equals(path)) {
            return 0;
        }
        String parentPath = PathUtils.getParentPath(path);
        if (PATH_SEPARATOR.equals(parentPath)) {
            return 0;
        }
        return 1 + PathUtils.getPathDepth(parentPath);
    }

    public static String getLCPPath(Collection<String> paths) {
        String lcp = null;
        for (String path : paths) {
            if (lcp == null) {
                lcp = path;
                continue;
            }
            lcp = PathUtils.getLCPPath(lcp, path);
        }
        return lcp;
    }

    public static String getLCPPath(String pathA, String pathB) {
        if (StringUtils.isEmpty((String)pathA) || StringUtils.isEmpty((String)pathB)) {
            return null;
        }
        if (pathA.equals(pathB)) {
            return pathA;
        }
        if (pathA.startsWith(pathB)) {
            return pathB;
        }
        if (pathB.startsWith(pathA)) {
            return pathA;
        }
        StringBuilder lcp = new StringBuilder();
        StringBuilder token = new StringBuilder();
        for (int index = 0; pathA.charAt(index) == pathB.charAt(index) && index < pathA.length() && index < pathB.length(); ++index) {
            token.append(pathA.charAt(index));
            if (pathA.charAt(index) != PATH_SEPARATOR.charAt(0)) continue;
            lcp.append((CharSequence)token);
            token.delete(0, token.length());
        }
        return lcp.toString();
    }

    public static final class Ident
    implements Function<String, String> {
        public String apply(@Nullable String input) {
            return input;
        }
    }
}

