/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.sonatype.nexus.util.PathUtils;

public class Node<P> {
    private final Node<P> parent;
    private final String label;
    private final P payload;
    private final LinkedHashMap<String, Node<P>> children;

    public Node(Node<P> parent, String label, P payload) {
        this.parent = parent;
        this.label = (String)Preconditions.checkNotNull((Object)label);
        this.payload = payload;
        this.children = new LinkedHashMap();
    }

    public Node<P> getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public int getDepth() {
        Node<P> currentNode = this;
        int result = 0;
        while (!currentNode.isRoot()) {
            currentNode = currentNode.getParent();
            ++result;
        }
        return result;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPath() {
        return PathUtils.pathFrom(this.getPathElements());
    }

    public List<String> getPathElements() {
        ArrayList<String> pathElems = new ArrayList<String>(this.getDepth());
        Node<P> current = this;
        do {
            if (current.isRoot()) continue;
            pathElems.add(current.getLabel());
            current = current.getParent();
        } while (!current.isRoot());
        Collections.reverse(pathElems);
        return pathElems;
    }

    public P getPayload() {
        return this.payload;
    }

    public Node<P> addChild(String label, P payload) {
        Node<P> node = new Node<P>(this, label, payload);
        this.children.put(node.getLabel(), node);
        return node;
    }

    public void removeChild(Node<P> child) {
        this.children.remove(child.getLabel());
    }

    public Node<P> getChildByLabel(String label) {
        return this.children.get(label);
    }

    public List<Node<P>> getChildren() {
        return new ImmutableList.Builder().addAll(this.children.values()).build();
    }
}

