/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.util;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.sisu.space.ClassSpace;

@Named(value="nexus-uber")
@Singleton
public class NexusUberClassloader
extends ClassLoader {
    private final List<ClassSpace> spaces;

    @Inject
    public NexusUberClassloader(List<ClassSpace> spaces) {
        this.spaces = (List)Preconditions.checkNotNull(spaces);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (ClassSpace s : this.spaces) {
            try {
                return s.loadClass(name);
            }
            catch (TypeNotPresentException typeNotPresentException) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL getResource(String name) {
        for (ClassSpace s : this.spaces) {
            URL result = s.getResource(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        ArrayList result = new ArrayList();
        for (ClassSpace s : this.spaces) {
            Enumeration resources = s.getResources(name);
            while (resources.hasMoreElements()) {
                result.add(resources.nextElement());
            }
        }
        return Collections.enumeration(result);
    }
}

