/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockFile {
    private static final Logger log = LoggerFactory.getLogger(LockFile.class);
    private static final byte[] DEFAULT_PAYLOAD = ManagementFactory.getRuntimeMXBean().getName().getBytes(Charset.forName("UTF-8"));
    private final File lockFile;
    private final byte[] payload;
    private FileLock fileLock;
    private RandomAccessFile randomAccessFile;

    public LockFile(File lockFile) {
        this(lockFile, DEFAULT_PAYLOAD);
    }

    public LockFile(File lockFile, byte[] payload) {
        this.lockFile = (File)Preconditions.checkNotNull((Object)lockFile);
        this.payload = (byte[])Preconditions.checkNotNull((Object)payload);
    }

    public File getFile() {
        return this.lockFile;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public synchronized boolean lock() {
        block7: {
            if (this.fileLock != null) {
                return true;
            }
            try {
                this.randomAccessFile = new RandomAccessFile(this.lockFile, "rws");
                this.fileLock = this.randomAccessFile.getChannel().tryLock(0L, 1L, false);
                if (this.fileLock != null) {
                    this.randomAccessFile.setLength(0L);
                    this.randomAccessFile.seek(0L);
                    this.randomAccessFile.write(this.payload);
                }
            }
            catch (IOException | OverlappingFileLockException e) {
                log.warn("Failed to write lock file", (Throwable)e);
                this.fileLock = null;
                return (boolean)this.fileLock;
            }
            finally {
                if (this.fileLock != null) break block7;
                this.release();
                return false;
            }
        }
        return true;
    }

    public synchronized void release() {
        this.close(this.fileLock);
        this.fileLock = null;
        this.close(this.randomAccessFile);
        this.randomAccessFile = null;
    }

    byte[] readBytes() throws IOException {
        Preconditions.checkState((this.randomAccessFile != null ? 1 : 0) != 0, (Object)"No lock obtained, cannot read file contents.");
        byte[] buffer = new byte[(int)this.randomAccessFile.length()];
        this.randomAccessFile.seek(0L);
        this.randomAccessFile.read(buffer, 0, buffer.length);
        return buffer;
    }

    private void close(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

