/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.user;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.nexus.user.UserAccountManager;
import org.sonatype.security.SecuritySystem;
import org.sonatype.security.authorization.AuthorizationException;
import org.sonatype.security.usermanagement.NoSuchUserManagerException;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserNotFoundException;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultUserAccountManager
extends ComponentSupport
implements UserAccountManager {
    private final SecuritySystem securitySystem;

    @Inject
    public DefaultUserAccountManager(SecuritySystem securitySystem) {
        this.securitySystem = securitySystem;
    }

    @Override
    public User readAccount(String userId) throws UserNotFoundException, AuthorizationException {
        this.checkPermission(userId);
        return this.securitySystem.getUser(userId);
    }

    @Override
    public User updateAccount(User user) throws InvalidConfigurationException, UserNotFoundException, NoSuchUserManagerException, AuthorizationException {
        this.checkPermission(user.getUserId());
        return this.securitySystem.updateUser(user);
    }

    protected void checkPermission(String userId) throws AuthorizationException {
        if (this.securitySystem.getSubject().getPrincipal().equals(userId)) {
            return;
        }
        this.securitySystem.checkPermission(this.securitySystem.getSubject().getPrincipals(), "security:users");
    }
}

