/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.threads;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.shiro.concurrent.SubjectAwareScheduledExecutorService;
import org.apache.shiro.subject.Subject;
import org.sonatype.nexus.threads.CurrentSubjectProvider;
import org.sonatype.nexus.threads.FixedSubjectProvider;
import org.sonatype.nexus.threads.MDCAwareCallable;
import org.sonatype.nexus.threads.MDCAwareRunnable;
import org.sonatype.nexus.threads.SubjectProvider;

public class NexusScheduledExecutorService
extends SubjectAwareScheduledExecutorService {
    private final SubjectProvider subjectProvider;

    public static NexusScheduledExecutorService forFixedSubject(ScheduledExecutorService target, Subject subject) {
        return new NexusScheduledExecutorService(target, new FixedSubjectProvider(subject));
    }

    public static NexusScheduledExecutorService forCurrentSubject(ScheduledExecutorService target) {
        return new NexusScheduledExecutorService(target, new CurrentSubjectProvider());
    }

    public NexusScheduledExecutorService(ScheduledExecutorService target, SubjectProvider subjectProvider) {
        super((ScheduledExecutorService)Preconditions.checkNotNull((Object)target));
        this.subjectProvider = (SubjectProvider)Preconditions.checkNotNull((Object)subjectProvider);
    }

    protected Subject getSubject() {
        return this.subjectProvider.getSubject();
    }

    protected Runnable associateWithSubject(Runnable r) {
        Subject subject = this.getSubject();
        return subject.associateWith((Runnable)new MDCAwareRunnable(r));
    }

    protected <T> Callable<T> associateWithSubject(Callable<T> task) {
        Subject subject = this.getSubject();
        return subject.associateWith(new MDCAwareCallable<T>(task));
    }
}

