/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.threads;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.shiro.concurrent.SubjectAwareExecutorService;
import org.apache.shiro.subject.Subject;
import org.sonatype.nexus.threads.CurrentSubjectProvider;
import org.sonatype.nexus.threads.FixedSubjectProvider;
import org.sonatype.nexus.threads.MDCAwareCallable;
import org.sonatype.nexus.threads.MDCAwareRunnable;
import org.sonatype.nexus.threads.SubjectProvider;

public class NexusExecutorService
extends SubjectAwareExecutorService {
    private final SubjectProvider subjectProvider;

    public static NexusExecutorService forFixedSubject(ExecutorService target, Subject subject) {
        return new NexusExecutorService(target, new FixedSubjectProvider(subject));
    }

    public static NexusExecutorService forCurrentSubject(ExecutorService target) {
        return new NexusExecutorService(target, new CurrentSubjectProvider());
    }

    public NexusExecutorService(ExecutorService target, SubjectProvider subjectProvider) {
        super((ExecutorService)Preconditions.checkNotNull((Object)target));
        this.subjectProvider = (SubjectProvider)Preconditions.checkNotNull((Object)subjectProvider);
    }

    protected Subject getSubject() {
        return this.subjectProvider.getSubject();
    }

    protected Runnable associateWithSubject(Runnable r) {
        Subject subject = this.getSubject();
        return subject.associateWith((Runnable)new MDCAwareRunnable(r));
    }

    protected <T> Callable<T> associateWithSubject(Callable<T> task) {
        Subject subject = this.getSubject();
        return subject.associateWith(new MDCAwareCallable<T>(task));
    }
}

