/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.threads;

import com.google.common.collect.Maps;
import java.util.Map;
import org.slf4j.MDC;
import org.sonatype.security.internal.UserIdMdcHelper;

public class MDCUtils {
    public static final String CONTEXT_NON_INHERITABLE_KEY = "non-inheritable";

    public static Map<String, String> getCopyOfContextMap() {
        boolean inheritable = MDC.get((String)CONTEXT_NON_INHERITABLE_KEY) == null;
        Map result = null;
        if (inheritable) {
            result = MDC.getCopyOfContextMap();
        }
        if (result == null) {
            result = Maps.newHashMap();
        }
        result.remove(CONTEXT_NON_INHERITABLE_KEY);
        return result;
    }

    public static void setContextMap(Map<String, String> context) {
        if (context != null) {
            MDC.setContextMap(context);
            UserIdMdcHelper.setIfNeeded();
        } else {
            MDC.clear();
            UserIdMdcHelper.set();
        }
    }
}

