/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.threads;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.Callable;
import org.sonatype.nexus.threads.MDCUtils;

public class MDCAwareCallable<T>
implements Callable<T> {
    private final Callable<T> delegate;
    private final Map<String, String> mdcContext;

    public MDCAwareCallable(Callable<T> delegate) {
        this.delegate = (Callable)Preconditions.checkNotNull(delegate);
        this.mdcContext = MDCUtils.getCopyOfContextMap();
    }

    @Override
    public T call() throws Exception {
        MDCUtils.setContextMap(this.mdcContext);
        return this.delegate.call();
    }
}

