/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.templates.repository;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.maven.RepositoryPolicy;
import org.sonatype.nexus.templates.TemplateSet;
import org.sonatype.nexus.templates.repository.AbstractRepositoryTemplateProvider;
import org.sonatype.nexus.templates.repository.maven.Maven1GroupRepositoryTemplate;
import org.sonatype.nexus.templates.repository.maven.Maven1HostedRepositoryTemplate;
import org.sonatype.nexus.templates.repository.maven.Maven1Maven2ShadowRepositoryTemplate;
import org.sonatype.nexus.templates.repository.maven.Maven1ProxyRepositoryTemplate;
import org.sonatype.nexus.templates.repository.maven.Maven2GroupRepositoryTemplate;
import org.sonatype.nexus.templates.repository.maven.Maven2HostedRepositoryTemplate;
import org.sonatype.nexus.templates.repository.maven.Maven2Maven1ShadowRepositoryTemplate;
import org.sonatype.nexus.templates.repository.maven.Maven2ProxyRepositoryTemplate;

@Named(value="default-repository")
@Singleton
public class DefaultRepositoryTemplateProvider
extends AbstractRepositoryTemplateProvider {
    public static final String PROVIDER_ID = "default-repository";
    private static final String DEFAULT_HOSTED_RELEASE = "default_hosted_release";
    private static final String DEFAULT_HOSTED_SNAPSHOT = "default_hosted_snapshot";
    private static final String DEFAULT_PROXY_RELEASE = "default_proxy_release";
    private static final String DEFAULT_PROXY_SNAPSHOT = "default_proxy_snapshot";
    private static final String DEFAULT_VIRTUAL_M2_M1 = "default_virtual_m2_m1";
    private static final String DEFAULT_VIRTUAL_M1_M2 = "default_virtual_m1_m2";
    private static final String DEFAULT_GROUP = "default_group";

    @Override
    public TemplateSet getTemplates() {
        TemplateSet templates = new TemplateSet((Object)null);
        try {
            templates.add(new Maven2HostedRepositoryTemplate(this, DEFAULT_HOSTED_RELEASE, "Maven2 (hosted, release)", RepositoryPolicy.RELEASE));
            templates.add(new Maven2HostedRepositoryTemplate(this, DEFAULT_HOSTED_SNAPSHOT, "Maven2 (hosted, snapshot)", RepositoryPolicy.SNAPSHOT));
            templates.add(new Maven2ProxyRepositoryTemplate(this, DEFAULT_PROXY_RELEASE, "Maven2 (proxy, release)", RepositoryPolicy.RELEASE));
            templates.add(new Maven2ProxyRepositoryTemplate(this, DEFAULT_PROXY_SNAPSHOT, "Maven2 (proxy, snapshot)", RepositoryPolicy.SNAPSHOT));
            templates.add(new Maven1Maven2ShadowRepositoryTemplate(this, DEFAULT_VIRTUAL_M1_M2, "Maven1 to Maven2 (virtual)"));
            templates.add(new Maven2Maven1ShadowRepositoryTemplate(this, DEFAULT_VIRTUAL_M2_M1, "Maven2 to Maven1 (virtual)"));
            templates.add(new Maven1HostedRepositoryTemplate(this, "maven1_hosted_release", "Maven1 (hosted, release)", RepositoryPolicy.RELEASE));
            templates.add(new Maven1HostedRepositoryTemplate(this, "maven1_hosted_snapshot", "Maven1 (hosted, snapshot)", RepositoryPolicy.SNAPSHOT));
            templates.add(new Maven1ProxyRepositoryTemplate(this, "maven1_proxy_release", "Maven1 (proxy, release)", RepositoryPolicy.RELEASE));
            templates.add(new Maven1ProxyRepositoryTemplate(this, "maven1_proxy_snapshot", "Maven1 (proxy, snapshot)", RepositoryPolicy.SNAPSHOT));
            templates.add(new Maven1GroupRepositoryTemplate(this, "maven1_group", "Maven1 (group)"));
            templates.add(new Maven2GroupRepositoryTemplate(this, DEFAULT_GROUP, "Maven2 (group)"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return templates;
    }
}

