/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.templates.repository;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.inject.Inject;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.application.NexusConfiguration;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryCoreConfiguration;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.registry.RepositoryTypeDescriptor;
import org.sonatype.nexus.proxy.registry.RepositoryTypeRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.storage.remote.RemoteProviderHintFactory;
import org.sonatype.nexus.templates.AbstractTemplateProvider;
import org.sonatype.nexus.templates.TemplateSet;
import org.sonatype.nexus.templates.repository.ManuallyConfiguredRepositoryTemplate;
import org.sonatype.nexus.templates.repository.RepositoryTemplate;

public abstract class AbstractRepositoryTemplateProvider
extends AbstractTemplateProvider<RepositoryTemplate> {
    private RepositoryTypeRegistry repositoryTypeRegistry;
    private NexusConfiguration nexusConfiguration;
    private RemoteProviderHintFactory remoteProviderHintFactory;

    @Inject
    public void setNexusConfiguration(NexusConfiguration nexusConfiguration) {
        this.nexusConfiguration = (NexusConfiguration)Preconditions.checkNotNull((Object)nexusConfiguration);
    }

    @Inject
    public void setRemoteProviderHintFactory(RemoteProviderHintFactory remoteProviderHintFactory) {
        this.remoteProviderHintFactory = (RemoteProviderHintFactory)Preconditions.checkNotNull((Object)remoteProviderHintFactory);
    }

    @Inject
    public void setRepositoryTypeRegistry(RepositoryTypeRegistry repositoryTypeRegistry) {
        this.repositoryTypeRegistry = (RepositoryTypeRegistry)Preconditions.checkNotNull((Object)repositoryTypeRegistry);
    }

    protected Repository createRepository(CRepository repository) throws ConfigurationException, IOException {
        return this.nexusConfiguration.createRepository(repository);
    }

    public RemoteProviderHintFactory getRemoteProviderHintFactory() {
        return this.remoteProviderHintFactory;
    }

    @Override
    public TemplateSet getTemplates(Object filter) {
        return this.getTemplates().getTemplates(filter);
    }

    @Override
    public TemplateSet getTemplates(Object ... filters) {
        return this.getTemplates().getTemplates(filters);
    }

    public ManuallyConfiguredRepositoryTemplate createManuallyTemplate(CRepositoryCoreConfiguration configuration) throws ConfigurationException {
        CRepository repoConfig = (CRepository)configuration.getConfiguration(false);
        RepositoryTypeDescriptor rtd = this.repositoryTypeRegistry.getRepositoryTypeDescriptor(repoConfig.getProviderRole(), repoConfig.getProviderHint());
        if (rtd == null) {
            String msg = String.format("Repository being created \"%s\" (repoId=%s) has corresponding type that is not registered in Core: Repository type %s:%s is unknown to Nexus Core. It is probably contributed by an old Nexus plugin. Please contact plugin developers to upgrade the plugin, and register the new repository type(s) properly!", repoConfig.getName(), repoConfig.getId(), repoConfig.getProviderRole(), repoConfig.getProviderHint());
            throw new ConfigurationException(msg);
        }
        ContentClass contentClass = this.repositoryTypeRegistry.getRepositoryContentClass(rtd.getRole(), rtd.getHint());
        return new ManuallyConfiguredRepositoryTemplate(this, "manual", "Manually created template", contentClass, null, configuration);
    }
}

