/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.templates.repository;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryCoreConfiguration;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.repository.ConfigurableRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.templates.AbstractConfigurableTemplate;
import org.sonatype.nexus.templates.repository.AbstractRepositoryTemplateProvider;
import org.sonatype.nexus.templates.repository.RepositoryTemplate;

public abstract class AbstractRepositoryTemplate
extends AbstractConfigurableTemplate
implements RepositoryTemplate {
    private final AbstractRepositoryTemplateProvider provider;
    private final ContentClass contentClass;
    private final Class<?> mainFacet;
    private ConfigurableRepository configurableRepository;

    public AbstractRepositoryTemplate(AbstractRepositoryTemplateProvider provider, String id, String description, ContentClass contentClass, Class<?> mainFacet) {
        super(provider, id, description);
        this.provider = provider;
        this.contentClass = contentClass;
        this.mainFacet = mainFacet != null ? mainFacet : Repository.class;
    }

    @Override
    public boolean targetFits(Object clazz) {
        return super.targetFits(clazz) || this.targetIsClassAndFitsClass(clazz, this.getMainFacet()) || this.targetIsClassAndFitsClass(clazz, this.getContentClass().getClass()) || this.getContentClass().equals(clazz) || clazz instanceof ProviderHint && ((ProviderHint)clazz).getValue().equals(this.getRepositoryProviderHint());
    }

    @Override
    public AbstractRepositoryTemplateProvider getTemplateProvider() {
        return this.provider;
    }

    @Override
    public ContentClass getContentClass() {
        return this.contentClass;
    }

    @Override
    public Class<?> getMainFacet() {
        return this.mainFacet;
    }

    @Override
    public ConfigurableRepository getConfigurableRepository() {
        if (this.configurableRepository == null) {
            this.configurableRepository = new ConfigurableRepository(this.getTemplateProvider().getApplicationConfiguration());
            try {
                this.configurableRepository.configure(this.getCoreConfiguration());
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        return this.configurableRepository;
    }

    @Override
    public Repository create() throws ConfigurationException, IOException {
        this.getCoreConfiguration().validateChanges();
        this.getCoreConfiguration().commitChanges();
        Repository repository = this.getTemplateProvider().createRepository((CRepository)this.getCoreConfiguration().getConfiguration(false));
        this.setCoreConfiguration(null);
        return repository;
    }

    @Override
    public String getRepositoryProviderRole() {
        return ((CRepository)this.getCoreConfiguration().getConfiguration(false)).getProviderRole();
    }

    @Override
    public String getRepositoryProviderHint() {
        return ((CRepository)this.getCoreConfiguration().getConfiguration(false)).getProviderHint();
    }

    @Override
    public CRepositoryCoreConfiguration getCoreConfiguration() {
        return (CRepositoryCoreConfiguration)super.getCoreConfiguration();
    }

    @Override
    protected abstract CRepositoryCoreConfiguration initCoreConfiguration();

    public static class ProviderHint {
        private final String value;

        public ProviderHint(String value) {
            this.value = (String)Preconditions.checkNotNull((Object)value);
        }

        public String getValue() {
            return this.value;
        }
    }
}

