/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.templates;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.templates.NoSuchTemplateIdException;
import org.sonatype.nexus.templates.Template;
import org.sonatype.nexus.templates.TemplateProvider;

public class TemplateSet
extends HashSet<Template>
implements TemplateProvider {
    private static final long serialVersionUID = 552419423510140977L;
    private final Object clazz;
    private final TemplateSet parent;

    public TemplateSet(Object clazz) {
        this(clazz, null);
    }

    public TemplateSet(Object clazz, TemplateSet templates) {
        this.clazz = clazz;
        this.parent = templates;
        if (this.parent != null) {
            if (clazz == null) {
                this.addAll(templates);
            } else {
                for (Template template : this.parent) {
                    if (!template.targetFits(clazz)) continue;
                    this.add(template);
                }
            }
        }
    }

    @Override
    public boolean add(Template elem) {
        if (this.getClazz() != null && elem.targetFits(this.getClazz())) {
            return super.add(elem);
        }
        if (this.getClazz() == null) {
            return super.add(elem);
        }
        return false;
    }

    public Template pick() throws IllegalStateException {
        return this.pick(true);
    }

    public Template pick(boolean forceSingleHit) throws IllegalStateException {
        if (!forceSingleHit || this.size() == 1) {
            return (Template)this.iterator().next();
        }
        throw new IllegalStateException("The TemplateSet has size()==\"" + this.size() + "\" and not 1 as forced!");
    }

    public Object getClazz() {
        return this.clazz;
    }

    public List<Template> getTemplatesList() {
        return new ArrayList<Template>(this);
    }

    @Override
    public TemplateSet getTemplates() {
        return this;
    }

    @Override
    public TemplateSet getTemplates(Object filter) {
        return new TemplateSet(filter, this);
    }

    @Override
    public TemplateSet getTemplates(Object ... filters) {
        TemplateSet par = this;
        for (Object filter : filters) {
            par = par.getTemplates(filter);
        }
        return par;
    }

    @Override
    public Template getTemplateById(String id) throws NoSuchTemplateIdException {
        for (Template template : this) {
            if (!StringUtils.equals((String)id, (String)template.getId())) continue;
            return template;
        }
        throw new NoSuchTemplateIdException("Template with Id='" + id + "' not found!");
    }
}

