/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.templates;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.templates.NoSuchTemplateIdException;
import org.sonatype.nexus.templates.Template;
import org.sonatype.nexus.templates.TemplateManager;
import org.sonatype.nexus.templates.TemplateProvider;
import org.sonatype.nexus.templates.TemplateSet;

@Named
@Singleton
public class DefaultTemplateManager
implements TemplateManager {
    private final List<TemplateProvider> providers;

    @Inject
    public DefaultTemplateManager(List<TemplateProvider> providers) {
        this.providers = (List)Preconditions.checkNotNull(providers);
    }

    @Override
    public TemplateSet getTemplates() {
        return this.getTemplates(null);
    }

    @Override
    public Template getTemplate(Object clazz, String id) throws NoSuchTemplateIdException {
        return this.getTemplates(clazz).getTemplateById(id);
    }

    protected TemplateSet getTemplates(Object clazz) {
        TemplateSet result = new TemplateSet(clazz);
        for (TemplateProvider provider : this.providers) {
            TemplateSet chunk = provider.getTemplates(clazz);
            result.addAll(chunk);
        }
        return result;
    }
}

