/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.templates;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.templates.NoSuchTemplateIdException;
import org.sonatype.nexus.templates.Template;
import org.sonatype.nexus.templates.TemplateProvider;
import org.sonatype.nexus.templates.TemplateSet;

public abstract class AbstractTemplateProvider<T extends Template>
implements TemplateProvider {
    private ApplicationConfiguration applicationConfiguration;

    @Inject
    public void setApplicationConfiguration(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = (ApplicationConfiguration)Preconditions.checkNotNull((Object)applicationConfiguration);
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    @Override
    public Template getTemplateById(String id) throws NoSuchTemplateIdException {
        TemplateSet templates = this.getTemplates();
        for (Template template : templates) {
            if (!StringUtils.equals((String)id, (String)template.getId())) continue;
            return template;
        }
        throw new NoSuchTemplateIdException("Template for Id='" + id + "' not found!");
    }
}

