/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.tasks.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.NumberTextFormField;
import org.sonatype.nexus.formfields.RepoOrGroupComboFormField;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.tasks.descriptors.AbstractScheduledTaskDescriptor;

@Named(value="ReconcileChecksums")
@Singleton
public class ReconcileChecksumsTaskDescriptor
extends AbstractScheduledTaskDescriptor {
    public static final String ID = "ReconcileChecksumsTask";
    public static final String REPO_OR_GROUP_FIELD_ID = "repositoryId";
    public static final String RESOURCE_STORE_PATH_FIELD_ID = "resourceStorePath";
    public static final String MODIFIED_SINCE_DATE_ID = "modifiedSinceDate";
    public static final String WALKING_LIMIT_TPS_FIELD_ID = "walkingLimitTps";
    private final RepoOrGroupComboFormField repoField = new RepoOrGroupComboFormField("repositoryId", true);
    private final StringTextFormField resourceStorePathField = new StringTextFormField("resourceStorePath", "Repository path", "Enter a repository path to run the task in recursively (ie. \"/\" for root or \"/org/apache\").", false);
    private final StringTextFormField modifiedSinceDateField = new StringTextFormField("modifiedSinceDate", "Modified since (yyyy-MM-dd)", "Enter a date to limit reconciliation to those checksum attributes modified since the given date.", false).withInitialValue("2015-01-01");
    private final NumberTextFormField walkingLimitTpsField = new NumberTextFormField("walkingLimitTps", "Walking limit (tps)", "Set the walking limit to reduce the overhead of this task at the expense of it taking more time.", false).withInitialValue(100);

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return "Reconcile Repository Checksums";
    }

    @Override
    public List<FormField> formFields() {
        ArrayList<FormField> fields = new ArrayList<FormField>();
        fields.add(this.repoField);
        fields.add(this.resourceStorePathField);
        fields.add(this.modifiedSinceDateField);
        fields.add(this.walkingLimitTpsField);
        return fields;
    }

    @Override
    public boolean isExposed() {
        return true;
    }
}

