/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.tasks;

import javax.inject.Named;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.proxy.repository.ShadowRepository;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesTask;

@Named(value="SynchronizeShadowsTask")
public class SynchronizeShadowsTask
extends AbstractNexusRepositoriesTask<Object> {
    public static final String ACTION = "SYNC_SHADOW";

    @Override
    protected String getRepositoryFieldId() {
        return "shadowRepositoryId";
    }

    public String getShadowRepositoryId() {
        return this.getRepositoryId();
    }

    public void setShadowRepositoryId(String shadowRepositoryId) {
        this.setRepositoryId(shadowRepositoryId);
    }

    @Override
    public String getRepositoryId() {
        return (String)this.getParameters().get(this.getRepositoryFieldId());
    }

    @Override
    public void setRepositoryId(String repositoryId) {
        if (!StringUtils.isEmpty((String)repositoryId)) {
            this.getParameters().put(this.getRepositoryFieldId(), repositoryId);
        }
    }

    @Override
    protected Object doRun() throws Exception {
        ShadowRepository shadow = this.getRepositoryRegistry().getRepositoryWithFacet(this.getShadowRepositoryId(), ShadowRepository.class);
        shadow.synchronizeWithMaster();
        return null;
    }

    @Override
    protected String getAction() {
        return ACTION;
    }

    @Override
    protected String getMessage() {
        return "Synchronizing virtual repository ID='" + this.getShadowRepositoryId() + "') with it's master repository.";
    }
}

