/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.tasks;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.ChecksumReconciler;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.walker.FixedRateWalkerThrottleController;
import org.sonatype.nexus.proxy.walker.WalkerThrottleController;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesPathAwareTask;
import org.sonatype.nexus.util.LinearNumberSequence;

@Named(value="ReconcileChecksumsTask")
public class ReconcileChecksumsTask
extends AbstractNexusRepositoriesPathAwareTask<Object> {
    public static final String ACTION = "RECONCILECHECKSUMS";
    private final ChecksumReconciler checksumReconciler;

    @Inject
    public ReconcileChecksumsTask(ChecksumReconciler checksumReconciler) {
        this.checksumReconciler = (ChecksumReconciler)((Object)Preconditions.checkNotNull((Object)((Object)checksumReconciler)));
    }

    @Override
    protected String getRepositoryFieldId() {
        return "repositoryId";
    }

    @Override
    protected String getRepositoryPathFieldId() {
        return "resourceStorePath";
    }

    public long getModifiedSinceMillis() {
        String value = this.getParameter("modifiedSinceDate");
        return StringUtils.isNotBlank((String)value) ? DateTime.parse((String)value).getMillis() : -1L;
    }

    public void setModifiedSinceDate(String modifiedSinceDate) {
        this.addParameter("modifiedSinceDate", modifiedSinceDate);
    }

    public int getWalkingLimitTps() {
        String value = this.getParameter("walkingLimitTps");
        return StringUtils.isNotBlank((String)value) ? Integer.parseInt(value) : -1;
    }

    public void setWalkingLimitTps(int walkingLimitTps) {
        this.addParameter("walkingLimitTps", Integer.toString(walkingLimitTps));
    }

    @Override
    public Object doRun() throws Exception {
        ArrayList<Object> targetRepositories = new ArrayList<Object>();
        if (this.getRepositoryId() != null) {
            Repository selectedRepository = this.getRepositoryRegistry().getRepository(this.getRepositoryId());
            GroupRepository groupRepository = selectedRepository.adaptToFacet(GroupRepository.class);
            if (groupRepository == null) {
                targetRepositories.add(selectedRepository);
            } else {
                targetRepositories.addAll(groupRepository.getTransitiveMemberRepositories());
            }
        } else {
            for (Repository repo : this.getRepositoryRegistry().getRepositories()) {
                if (repo.adaptToFacet(GroupRepository.class) != null) continue;
                targetRepositories.add(repo);
            }
        }
        ResourceStoreRequest request = new ResourceStoreRequest(this.getResourceStorePath(), true, false);
        int limitTps = this.getWalkingLimitTps();
        if (limitTps > 0) {
            request.getRequestContext().put(WalkerThrottleController.CONTEXT_KEY, (Object)new FixedRateWalkerThrottleController(limitTps, new LinearNumberSequence(0L, 1L, 1L, 0L)));
        }
        for (Repository repository : targetRepositories) {
            this.checksumReconciler.reconcileChecksums(repository, request, this.getModifiedSinceMillis());
        }
        return null;
    }

    @Override
    protected String getAction() {
        return ACTION;
    }

    @Override
    protected String getMessage() {
        String message = this.getRepositoryId() != null ? "Reconciling checksums of repository " + this.getRepositoryName() : "Reconciling checksums of all registered repositories";
        return message + " from path " + this.getResourceStorePath() + " and below.";
    }
}

