/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.tasks;

import java.util.HashMap;
import java.util.List;
import javax.inject.Named;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesPathAwareTask;

@Named(value="RebuildAttributesTask")
public class RebuildAttributesTask
extends AbstractNexusRepositoriesPathAwareTask<Object> {
    public static final String ACTION = "REBUILDATTRIBUTES";

    @Override
    protected String getRepositoryFieldId() {
        return "repositoryId";
    }

    @Override
    protected String getRepositoryPathFieldId() {
        return "resourceStorePath";
    }

    @Override
    public Object doRun() throws Exception {
        ResourceStoreRequest req = new ResourceStoreRequest(this.getResourceStorePath());
        HashMap<String, String> initialData = new HashMap<String, String>();
        if (this.getRepositoryId() != null) {
            this.getRepositoryRegistry().getRepository(this.getRepositoryId()).recreateAttributes(req, initialData);
        } else {
            List<Repository> reposes = this.getRepositoryRegistry().getRepositories();
            for (Repository repo : reposes) {
                repo.recreateAttributes(req, null);
            }
        }
        return null;
    }

    @Override
    protected String getAction() {
        return ACTION;
    }

    @Override
    protected String getMessage() {
        if (this.getRepositoryId() != null) {
            return "Rebuilding attributes of repository " + this.getRepositoryName() + " from path " + this.getResourceStorePath() + " and below.";
        }
        return "Rebuilding attributes of all registered repositories from path " + this.getResourceStorePath() + " and below.";
    }
}

