/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.tasks;

import javax.inject.Named;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesPathAwareTask;

@Named(value="ExpireCacheTask")
public class ExpireCacheTask
extends AbstractNexusRepositoriesPathAwareTask<Object> {
    public static final String ACTION = "EXPIRE_CACHE";

    @Override
    protected String getRepositoryFieldId() {
        return "repositoryId";
    }

    @Override
    protected String getRepositoryPathFieldId() {
        return "resourceStorePath";
    }

    @Override
    public Object doRun() throws Exception {
        ResourceStoreRequest req = new ResourceStoreRequest(this.getResourceStorePath());
        if (this.getRepositoryId() != null) {
            this.getRepositoryRegistry().getRepository(this.getRepositoryId()).expireCaches(req);
        } else {
            for (Repository repository : this.getRepositoryRegistry().getRepositories()) {
                if (!repository.getLocalStatus().shouldServiceRequest()) continue;
                repository.expireCaches(req);
            }
        }
        return null;
    }

    @Override
    protected String getAction() {
        return ACTION;
    }

    @Override
    protected String getMessage() {
        if (this.getRepositoryId() != null) {
            return "Expiring caches for repository " + this.getRepositoryName() + " from path " + this.getResourceStorePath() + " and below.";
        }
        return "Expiring caches for all registered repositories from path " + this.getResourceStorePath() + " and below.";
    }
}

