/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.tasks;

import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Named;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesTask;

@Named(value="EvictUnusedProxiedItemsTask")
public class EvictUnusedProxiedItemsTask
extends AbstractNexusRepositoriesTask<Collection<String>> {
    public static final String ACTION = "EVICT_UNUSED_PROXIED_ITEMS";

    @Override
    protected String getRepositoryFieldId() {
        return "repositoryId";
    }

    public int getEvictOlderCacheItemsThen() {
        return Integer.parseInt((String)this.getParameters().get("evictOlderCacheItemsThen"));
    }

    public void setEvictOlderCacheItemsThen(int evictOlderCacheItemsThen) {
        this.getParameters().put("evictOlderCacheItemsThen", Integer.toString(evictOlderCacheItemsThen));
    }

    @Override
    protected Collection<String> doRun() throws Exception {
        ResourceStoreRequest req = new ResourceStoreRequest("/");
        long olderThan = System.currentTimeMillis() - (long)this.getEvictOlderCacheItemsThen() * 86400000L;
        if (this.getRepositoryId() != null) {
            return this.getRepositoryRegistry().getRepository(this.getRepositoryId()).evictUnusedItems(req, olderThan);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Repository repository : this.getRepositoryRegistry().getRepositories()) {
            result.addAll(repository.evictUnusedItems(req, olderThan));
        }
        return result;
    }

    @Override
    protected String getAction() {
        return ACTION;
    }

    @Override
    protected String getMessage() {
        if (this.getRepositoryId() != null) {
            return "Evicting unused proxied items for repository " + this.getRepositoryName() + ".";
        }
        return "Evicting unused proxied items for all registered proxy repositories.";
    }
}

