/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.tasks;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.proxy.wastebasket.Wastebasket;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesTask;

@Named(value="EmptyTrashTask")
public class EmptyTrashTask
extends AbstractNexusRepositoriesTask<Object> {
    public static final String ACTION = "EMPTY_TRASH";
    public static final int DEFAULT_OLDER_THAN_DAYS = -1;
    private final Wastebasket wastebasket;

    @Inject
    public EmptyTrashTask(Wastebasket wastebasket) {
        this.wastebasket = (Wastebasket)Preconditions.checkNotNull((Object)wastebasket);
    }

    @Override
    protected Object doRun() throws Exception {
        String repositoryId = this.getRepositoryId();
        if (this.getEmptyOlderCacheItemsThan() == -1) {
            if (repositoryId == null) {
                this.wastebasket.purgeAll();
            } else {
                this.wastebasket.purge(this.getRepositoryRegistry().getRepository(repositoryId));
            }
        } else if (repositoryId == null) {
            this.wastebasket.purgeAll((long)this.getEmptyOlderCacheItemsThan() * 86400000L);
        } else {
            this.wastebasket.purge(this.getRepositoryRegistry().getRepository(repositoryId), (long)this.getEmptyOlderCacheItemsThan() * 86400000L);
        }
        return null;
    }

    @Override
    protected String getAction() {
        return ACTION;
    }

    @Override
    protected String getMessage() {
        return "Emptying Trash.";
    }

    @Override
    protected String getRepositoryFieldId() {
        return "repositoryId";
    }

    public int getEmptyOlderCacheItemsThan() {
        String days = (String)this.getParameters().get("EmptyTrashItemsOlderThan");
        if (StringUtils.isEmpty((String)days)) {
            return -1;
        }
        return Integer.parseInt(days);
    }

    public void setEmptyOlderCacheItemsThan(int emptyOlderCacheItemsThan) {
        this.getParameters().put("EmptyTrashItemsOlderThan", Integer.toString(emptyOlderCacheItemsThan));
    }
}

