/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.tasks;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.wastebasket.RepositoryFolderRemover;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesTask;

@Named(value="DeleteRepositoryFoldersTask")
public class DeleteRepositoryFoldersTask
extends AbstractNexusRepositoriesTask<Object> {
    public static final String ACTION = "REMOVE_REPO_FOLDER";
    private final RepositoryFolderRemover repositoryFolderRemover;
    private boolean deleteForever = false;
    private Repository repository = null;

    @Inject
    public DeleteRepositoryFoldersTask(RepositoryFolderRemover repositoryFolderRemover) {
        this.repositoryFolderRemover = (RepositoryFolderRemover)Preconditions.checkNotNull((Object)repositoryFolderRemover);
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
        this.setRepositoryId(repository.getId());
    }

    public boolean isDeleteForever() {
        return this.deleteForever;
    }

    public void setDeleteForever(boolean deleteForever) {
        this.deleteForever = deleteForever;
    }

    @Override
    public boolean isExposed() {
        return false;
    }

    @Override
    protected Object doRun() throws Exception {
        if (this.repository != null) {
            try {
                this.repositoryFolderRemover.deleteRepositoryFolders(this.repository, this.deleteForever);
            }
            catch (IOException e) {
                this.getLogger().warn("Unable to delete repository folders ", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    protected String getAction() {
        return ACTION;
    }

    @Override
    protected String getMessage() {
        if (this.getRepositoryId() != null) {
            return "Deleting folders with repository ID: " + this.getRepositoryId();
        }
        return null;
    }

    @Override
    public String getRepositoryName() {
        return this.repository.getName();
    }
}

