/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.filter.authz;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.router.RepositoryRouter;
import org.sonatype.nexus.security.filter.authz.AbstractNexusAuthorizationFilter;
import org.sonatype.sisu.goodies.common.Loggers;

public class NexusTargetMappingAuthorizationFilter
extends AbstractNexusAuthorizationFilter {
    private static final String ACTION_KEY = NexusTargetMappingAuthorizationFilter.class.getName() + ".action";
    private static final Logger log = Loggers.getLogger(NexusTargetMappingAuthorizationFilter.class);
    @Inject
    private RepositoryRouter rootRouter;
    private String pathReplacement;

    public String getPathReplacement() {
        if (this.pathReplacement == null) {
            this.pathReplacement = "";
        }
        return this.pathReplacement;
    }

    public void setPathReplacement(String pathReplacement) {
        this.pathReplacement = pathReplacement;
    }

    @Nullable
    private String getResourceStorePath(ServletRequest request) {
        String path = WebUtils.getPathWithinApplication((HttpServletRequest)((HttpServletRequest)request));
        if (this.getPathPrefix() != null) {
            Pattern p = this.getPathPrefixPattern();
            Matcher m = p.matcher(path);
            if (m.matches()) {
                path = this.getPathReplacement();
                if (path.contains("@1")) {
                    path = path.replaceAll("@1", Matcher.quoteReplacement(m.group(1)));
                }
                if (path.contains("@2")) {
                    path = path.replaceAll("@2", Matcher.quoteReplacement(m.group(2)));
                }
            } else {
                log.warn(this.formatMessage(request, "Cannot translate request to Nexus repository path, expected pattern {}"), (Object)p);
                return null;
            }
        }
        return path;
    }

    @Nullable
    private ResourceStoreRequest getResourceStoreRequest(ServletRequest request, boolean localOnly) {
        String resourceStorePath = this.getResourceStorePath(request);
        if (resourceStorePath == null) {
            return null;
        }
        ResourceStoreRequest rsr = new ResourceStoreRequest(resourceStorePath, localOnly, false);
        rsr.getRequestContext().put("request.auth.check.only", (Object)true);
        return rsr;
    }

    protected String getHttpMethodAction(ServletRequest request) {
        if (request.getAttribute(ACTION_KEY) == null) {
            String method = ((HttpServletRequest)request).getMethod().toLowerCase();
            if ("put".equals(method)) {
                try {
                    ResourceStoreRequest storeRequest = this.getResourceStoreRequest(request, true);
                    if (storeRequest != null) {
                        this.rootRouter.retrieveItem(storeRequest);
                    }
                }
                catch (ItemNotFoundException e) {
                    method = "post";
                }
                catch (AccessDeniedException e) {
                    method = "post";
                }
                catch (Exception e) {
                    throw new IllegalStateException(this.formatMessage(request, "Cannot translate request to Nexus action"), e);
                }
            }
            request.setAttribute(ACTION_KEY, (Object)super.getHttpMethodAction(method));
        }
        return (String)request.getAttribute(ACTION_KEY);
    }

    public boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws IOException {
        if (mappedValue != null && !super.isAccessAllowed(request, response, mappedValue)) {
            return false;
        }
        String action = this.getHttpMethodAction(request);
        try {
            Action nxAction = Action.valueOf(action);
            ResourceStoreRequest storeRequest = this.getResourceStoreRequest(request, false);
            return storeRequest != null && this.rootRouter.authorizePath(storeRequest, nxAction);
        }
        catch (IllegalArgumentException e) {
            log.warn(this.formatMessage(request, "Cannot translate Shiro action '{}' to Nexus action"), (Object)action);
            return false;
        }
    }

    private String formatMessage(ServletRequest request, String message) {
        StringBuilder sb = new StringBuilder(message);
        if (request instanceof HttpServletRequest) {
            HttpServletRequest hsr = (HttpServletRequest)request;
            sb.append(", request: ").append(hsr.getMethod()).append(" ").append(hsr.getRequestURL());
            String query = hsr.getQueryString();
            if (!Strings.isNullOrEmpty((String)query)) {
                sb.append("?").append(query);
            }
        }
        return sb.toString();
    }
}

