/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.filter.authz;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authz.HttpMethodPermissionFilter;
import org.sonatype.nexus.auth.ClientInfo;
import org.sonatype.nexus.auth.NexusAuthorizationEvent;
import org.sonatype.nexus.auth.ResourceInfo;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.web.RemoteIPFinder;
import org.sonatype.security.SecuritySystem;
import org.sonatype.sisu.goodies.eventbus.EventBus;

public class FailureLoggingHttpMethodPermissionFilter
extends HttpMethodPermissionFilter {
    @Inject
    private SecuritySystem securitySystem;
    @Inject
    private EventBus eventBus;

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws IOException {
        this.recordAuthzFailureEvent(request, response);
        request.setAttribute("request.is.authz.rejected", (Object)Boolean.TRUE);
        return false;
    }

    private void recordAuthzFailureEvent(ServletRequest request, ServletResponse response) {
        Subject subject = this.getSubject(request, response);
        if (this.securitySystem.getAnonymousUsername().equals(subject.getPrincipal())) {
            return;
        }
        Action action = Action.valueOf(this.getHttpMethodAction(request));
        ClientInfo clientInfo = new ClientInfo(String.valueOf(subject.getPrincipal()), RemoteIPFinder.findIP((HttpServletRequest)request), "n/a");
        ResourceInfo resInfo = new ResourceInfo("HTTP", ((HttpServletRequest)request).getMethod(), action, ((HttpServletRequest)request).getRequestURI());
        this.eventBus.post((Object)new NexusAuthorizationEvent((Object)this, clientInfo, resInfo, false));
    }
}

