/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.filter.authc;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExpiredCredentialsException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.auth.ClientInfo;
import org.sonatype.nexus.auth.NexusAuthenticationEvent;
import org.sonatype.nexus.web.BaseUrlHolder;
import org.sonatype.nexus.web.RemoteIPFinder;
import org.sonatype.nexus.web.TemplateRenderer;
import org.sonatype.nexus.web.internal.BrowserDetector;
import org.sonatype.security.SecuritySystem;
import org.sonatype.sisu.goodies.common.Loggers;
import org.sonatype.sisu.goodies.eventbus.EventBus;

public class NexusHttpAuthenticationFilter
extends BasicHttpAuthenticationFilter {
    public static final String AUTH_SCHEME_KEY = "auth.scheme";
    public static final String AUTH_REALM_KEY = "auth.realm";
    public static final String FAKE_AUTH_SCHEME = "NxBASIC";
    public static final String ANONYMOUS_LOGIN = "nexus.anonymous";
    private final Logger logger = Loggers.getLogger(((Object)((Object)this)).getClass());
    private boolean fakeAuthScheme;
    @Inject
    private SecuritySystem securitySystem;
    @Inject
    private EventBus eventBus;
    @Inject
    private TemplateRenderer templateRenderer;
    @Inject
    private BrowserDetector browserDetector;
    private String nexusVersion;

    @Inject
    public void setApplicationVersion(ApplicationStatusSource applicationStatusSource) {
        this.nexusVersion = applicationStatusSource.getSystemStatus().getVersion();
    }

    protected SecuritySystem getSecuritySystem() {
        return this.securitySystem;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public String isFakeAuthScheme() {
        return Boolean.toString(this.fakeAuthScheme);
    }

    public void setFakeAuthScheme(String fakeAuthSchemeStr) {
        this.fakeAuthScheme = Boolean.parseBoolean(fakeAuthSchemeStr);
        if (this.fakeAuthScheme) {
            this.setAuthcScheme(FAKE_AUTH_SCHEME);
            this.setAuthzScheme(FAKE_AUTH_SCHEME);
        } else {
            this.setAuthcScheme("BASIC");
            this.setAuthzScheme("BASIC");
        }
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        Subject subject = this.getSubject(request, response);
        boolean loggedIn = subject.isAuthenticated();
        if (loggedIn) {
            return true;
        }
        if (this.isLoginAttempt(request, response)) {
            AuthenticationToken token = this.createToken(request, response);
            String anonymousUsername = this.getSecuritySystem().getAnonymousUsername();
            String loginUsername = token.getPrincipal().toString();
            if (!this.getSecuritySystem().isAnonymousAccessEnabled() && StringUtils.equals((String)anonymousUsername, (String)loginUsername)) {
                this.getLogger().info("Login attempt with username \"" + anonymousUsername + "\" (used for Anonymous Access) while Anonymous Access is disabled.");
                loggedIn = false;
            } else {
                try {
                    loggedIn = this.executeLogin(request, response);
                }
                catch (Exception e) {
                    this.getLogger().error("Unable to login", (Throwable)e);
                    loggedIn = false;
                }
            }
        } else if (this.getSecuritySystem().isAnonymousAccessEnabled()) {
            loggedIn = this.executeAnonymousLogin(request, response);
        }
        if (!loggedIn) {
            this.sendChallenge(request, response);
        } else {
            request.setAttribute(AUTH_SCHEME_KEY, (Object)this.getAuthcScheme());
            request.setAttribute(AUTH_REALM_KEY, (Object)this.getApplicationName());
        }
        return loggedIn;
    }

    protected String getUnauthorizedMessage(ServletRequest request) {
        return "Unauthorized";
    }

    protected boolean sendChallenge(ServletRequest request, ServletResponse response) {
        if (this.browserDetector.isBrowserInitiated(request)) {
            HttpServletResponse httpResponse = WebUtils.toHttp((ServletResponse)response);
            httpResponse.setStatus(401, this.getUnauthorizedMessage(request));
            ImmutableMap params = ImmutableMap.of((Object)"nexusVersion", (Object)this.nexusVersion, (Object)"nexusRoot", (Object)BaseUrlHolder.get());
            TemplateRenderer.TemplateLocator template = this.templateRenderer.template("/org/sonatype/nexus/web/internal/accessDeniedHtml.vm", NexusHttpAuthenticationFilter.class.getClassLoader());
            try {
                this.templateRenderer.render(template, (Map<String, Object>)params, httpResponse);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            return false;
        }
        String message = this.getUnauthorizedMessage(request);
        this.getLogger().debug("Authentication required: sending 401 Authentication challenge response: {}", (Object)message);
        HttpServletResponse httpResponse = WebUtils.toHttp((ServletResponse)response);
        httpResponse.setStatus(401, message);
        String authcHeader = this.getAuthcScheme() + " realm=\"" + this.getApplicationName() + "\"";
        httpResponse.setHeader("WWW-Authenticate", authcHeader);
        return false;
    }

    protected boolean isLoginAttempt(String authzHeader) {
        String authzHeaderScheme = this.getAuthzScheme().toLowerCase();
        if (authzHeader.toLowerCase().startsWith("BASIC".toLowerCase())) {
            return true;
        }
        return super.isLoginAttempt(authzHeaderScheme);
    }

    protected boolean executeAnonymousLogin(ServletRequest request, ServletResponse response) {
        boolean anonymousLoginSuccessful;
        block6: {
            this.getLogger().debug("Attempting to authenticate Subject as Anonymous request...");
            anonymousLoginSuccessful = false;
            Subject subject = this.getSubject(request, response);
            request.setAttribute(DefaultSubjectContext.SESSION_CREATION_ENABLED, (Object)Boolean.FALSE);
            UsernamePasswordToken usernamePasswordToken = new UsernamePasswordToken(this.getSecuritySystem().getAnonymousUsername(), this.getSecuritySystem().getAnonymousPassword());
            try {
                request.setAttribute(ANONYMOUS_LOGIN, (Object)Boolean.TRUE);
                subject.login((AuthenticationToken)usernamePasswordToken);
                anonymousLoginSuccessful = true;
            }
            catch (UnknownSessionException e) {
                Session anonSession = subject.getSession(false);
                this.getLogger().debug("Unknown session exception while logging in anonymous user: '{}' with principal '{}'", new Object[]{anonSession, usernamePasswordToken.getUsername(), e});
                if (anonSession == null) break block6;
                this.getLogger().debug("Logging out the current anonymous user, to clear the session.");
                try {
                    subject.logout();
                }
                catch (UnknownSessionException expectedException) {
                    this.logger.trace("Forced a logout with an Unknown Session so the current subject would get cleaned up.", (Throwable)e);
                }
                this.getLogger().debug("Attempting to login as anonymous for the second time.");
                subject.login((AuthenticationToken)usernamePasswordToken);
                anonymousLoginSuccessful = true;
            }
            catch (AuthenticationException ae) {
                this.getLogger().info("Unable to authenticate user [anonymous] from IP Address " + RemoteIPFinder.findIP((HttpServletRequest)request));
                this.getLogger().debug("Unable to log in subject as anonymous", (Throwable)ae);
            }
        }
        if (anonymousLoginSuccessful) {
            this.getLogger().debug("Successfully logged in as anonymous");
            this.postAuthcEvent(request, this.getSecuritySystem().getAnonymousUsername(), this.getUserAgent(request), true);
            return true;
        }
        return false;
    }

    private void postAuthcEvent(ServletRequest request, String username, String userAgent, boolean success) {
        if (this.eventBus != null) {
            this.eventBus.post((Object)new NexusAuthenticationEvent((Object)this, new ClientInfo(username, RemoteIPFinder.findIP((HttpServletRequest)request), userAgent), success));
        }
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) {
        Object principal = subject.getPrincipal();
        if (principal == null) {
            principal = token.getPrincipal();
        }
        String userId = principal.toString();
        if (request instanceof HttpServletRequest) {
            ((HttpServletRequest)request).setAttribute("nexus.user.principal", principal);
            ((HttpServletRequest)request).setAttribute("nexus.user.id", (Object)userId);
        }
        this.postAuthcEvent(request, userId, this.getUserAgent(request), true);
        return true;
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException ae, ServletRequest request, ServletResponse response) {
        this.postAuthcEvent(request, token.getPrincipal().toString(), this.getUserAgent(request), false);
        HttpServletResponse httpResponse = WebUtils.toHttp((ServletResponse)response);
        if (ExpiredCredentialsException.class.isAssignableFrom(((Object)((Object)ae)).getClass())) {
            httpResponse.addHeader("X-Nexus-Reason", "expired");
        }
        return false;
    }

    public void postHandle(ServletRequest request, ServletResponse response) throws Exception {
        if (request.getAttribute("request.is.authz.rejected") != null) {
            if (request.getAttribute(ANONYMOUS_LOGIN) != null) {
                this.sendChallenge(request, response);
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    Subject subject = this.getSubject(request, response);
                    String username = subject != null && subject.isAuthenticated() && subject.getPrincipal() != null ? subject.getPrincipal().toString() : this.getSecuritySystem().getAnonymousUsername();
                    this.getLogger().debug("Request processing is rejected because user \"" + username + "\" lacks permissions.");
                }
                this.sendForbidden(request, response);
            }
        }
    }

    protected void sendForbidden(ServletRequest request, ServletResponse response) throws IOException {
        HttpServletResponse httpResponse = WebUtils.toHttp((ServletResponse)response);
        httpResponse.sendError(403);
    }

    protected String getAuthzHeader(ServletRequest request) {
        String authzHeader = super.getAuthzHeader(request);
        if (!StringUtils.isEmpty((String)authzHeader)) {
            this.getLogger().debug("Using authorization header from request");
            return authzHeader;
        }
        authzHeader = request.getParameter("authorization");
        if (!StringUtils.isEmpty((String)authzHeader)) {
            this.getLogger().debug("Using authorization from request parameter");
        } else {
            this.getLogger().debug("No authorization found (header or request parameter)");
        }
        return authzHeader;
    }

    protected String[] getPrincipalsAndCredentials(String scheme, String encoded) {
        if (StringUtils.isEmpty((String)encoded)) {
            return null;
        }
        String decoded = Base64.decodeToString((String)encoded);
        if (StringUtils.isEmpty((String)encoded)) {
            return null;
        }
        String[] parts = decoded.split(":");
        if (parts == null || parts.length < 2) {
            return null;
        }
        return new String[]{parts[0], decoded.substring(parts[0].length() + 1)};
    }

    protected Object getAttribute(String key) {
        return this.getFilterConfig().getServletContext().getAttribute(key);
    }

    private String getUserAgent(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            String userAgent = ((HttpServletRequest)request).getHeader("User-Agent");
            return userAgent;
        }
        return null;
    }
}

