/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.filter.authc;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.authc.AuthenticationToken;
import org.sonatype.nexus.security.filter.authc.AuthenticationTokenFactory;
import org.sonatype.nexus.security.filter.authc.NexusHttpAuthenticationFilter;

public class NexusAuthenticationFilter
extends NexusHttpAuthenticationFilter {
    private List<AuthenticationTokenFactory> factories = Lists.newArrayList();

    @Inject
    public void install(List<AuthenticationTokenFactory> factories) {
        this.factories = (List)Preconditions.checkNotNull(factories);
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        if (this.isLoginAttempt(request, response)) {
            try {
                return this.executeLogin(request, response) && super.isAccessAllowed(request, response, mappedValue);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return super.isAccessAllowed(request, response, mappedValue);
    }

    protected boolean isLoginAttempt(ServletRequest request, ServletResponse response) {
        AuthenticationToken token = this.createAuthenticationToken(request, response);
        return token != null || super.isLoginAttempt(request, response);
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        AuthenticationToken token = this.createAuthenticationToken(request, response);
        if (token != null) {
            return token;
        }
        return super.createToken(request, response);
    }

    private AuthenticationToken createAuthenticationToken(ServletRequest request, ServletResponse response) {
        for (AuthenticationTokenFactory factory : this.factories) {
            try {
                AuthenticationToken token = factory.createToken(request, response);
                if (token == null) continue;
                this.getLogger().debug("Token '{}' created by {}", (Object)token, (Object)factory);
                return token;
            }
            catch (Exception e) {
                this.getLogger().warn("Factory {} failed to create an authentication token {}/{}", new Object[]{factory, e.getClass().getName(), e.getMessage(), this.getLogger().isDebugEnabled() ? e : null});
            }
        }
        return null;
    }
}

