/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.filter.authc;

import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.util.WebUtils;
import org.sonatype.nexus.security.filter.authc.NexusApiKey;
import org.sonatype.nexus.security.filter.authc.NexusApiKeyAuthenticationToken;
import org.sonatype.nexus.security.filter.authc.NexusHttpAuthenticationFilter;

public class NexusApiKeyAuthenticationFilter
extends NexusHttpAuthenticationFilter {
    @Inject
    private Map<String, NexusApiKey> apiKeys = Collections.emptyMap();

    protected boolean isLoginAttempt(ServletRequest request, ServletResponse response) {
        HttpServletRequest http = WebUtils.toHttp((ServletRequest)request);
        for (String key : this.apiKeys.keySet()) {
            if (null == http.getHeader(key)) continue;
            return true;
        }
        return super.isLoginAttempt(request, response);
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        HttpServletRequest http = WebUtils.toHttp((ServletRequest)request);
        for (String key : this.apiKeys.keySet()) {
            String token = http.getHeader(key);
            if (null == token) continue;
            return new NexusApiKeyAuthenticationToken(key, token.toCharArray(), request.getRemoteHost());
        }
        return super.createToken(request, response);
    }
}

