/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.filter;

import com.google.inject.AbstractModule;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Filter;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.sonatype.nexus.security.filter.FilterProviderSupport;
import org.sonatype.nexus.security.filter.authc.NexusApiKeyAuthenticationFilter;
import org.sonatype.nexus.security.filter.authc.NexusAuthenticationFilter;
import org.sonatype.nexus.security.filter.authz.FailureLoggingHttpMethodPermissionFilter;
import org.sonatype.security.web.filter.authc.LogoutAuthenticationFilter;

@Named
public class NexusSecurityFilterModule
extends AbstractModule {
    protected void configure() {
        this.requireBinding(FilterChainResolver.class);
        this.bind(FilterProviderSupport.filterKey("authcBasic")).toProvider(AuthcBasicFilterProvider.class);
        this.bind(FilterProviderSupport.filterKey("authcNxBasic")).toProvider(AuthcNxBasicFilterProvider.class);
        this.bind(FilterProviderSupport.filterKey("logout")).to(LogoutAuthenticationFilter.class).in(Singleton.class);
        this.bind(FilterProviderSupport.filterKey("perms")).to(FailureLoggingHttpMethodPermissionFilter.class).in(Singleton.class);
        this.bind(FilterProviderSupport.filterKey("authcApiKey")).toProvider(AuthcApiKeyFilterProvider.class);
    }

    @Singleton
    static class AuthcApiKeyFilterProvider
    extends FilterProviderSupport {
        @Inject
        AuthcApiKeyFilterProvider(NexusApiKeyAuthenticationFilter filter) {
            super((Filter)filter);
            filter.setApplicationName("Sonatype Nexus Repository Manager API (X-...-ApiKey auth)");
        }
    }

    @Singleton
    static class AuthcNxBasicFilterProvider
    extends FilterProviderSupport {
        @Inject
        AuthcNxBasicFilterProvider(NexusAuthenticationFilter filter) {
            super((Filter)filter);
            filter.setApplicationName("Sonatype Nexus Repository Manager API (specialized auth)");
            filter.setFakeAuthScheme(Boolean.toString(true));
        }
    }

    @Singleton
    static class AuthcBasicFilterProvider
    extends FilterProviderSupport {
        @Inject
        AuthcBasicFilterProvider(NexusAuthenticationFilter filter) {
            super((Filter)filter);
            filter.setApplicationName("Sonatype Nexus Repository Manager API");
            filter.setFakeAuthScheme(Boolean.toString(false));
        }
    }
}

