/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security;

import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.security.usermanagement.NoSuchUserManagerException;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserManager;
import org.sonatype.security.usermanagement.UserNotFoundException;
import org.sonatype.security.usermanagement.UserNotFoundTransientException;
import org.sonatype.security.usermanagement.UserStatus;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class UserPrincipalsHelper
extends ComponentSupport {
    @Inject
    private List<UserManager> userManagers;

    public UserStatus getUserStatus(PrincipalCollection principals) throws UserNotFoundException {
        String userId = null;
        if (principals != null) {
            userId = principals.getPrimaryPrincipal().toString();
            try {
                User user = this.findUserManager(principals).getUser(userId);
                if (user != null) {
                    return user.getStatus();
                }
            }
            catch (NoSuchUserManagerException e) {
                throw new UserNotFoundException(userId, e.getMessage(), (Throwable)e);
            }
            catch (UserNotFoundTransientException e) {
                this.log.debug("Ignoring transient user error: {}", (Throwable)e);
                return UserStatus.disabled;
            }
            catch (UserNotFoundException e) {
                throw e;
            }
            catch (RuntimeException e) {
                this.log.debug("Ignoring transient user error: {}", (Throwable)e);
                return UserStatus.disabled;
            }
        }
        throw new UserNotFoundException(userId);
    }

    public UserManager findUserManager(PrincipalCollection principals) throws NoSuchUserManagerException {
        Iterator itr;
        String primaryRealmName = null;
        if (principals != null && (itr = principals.getRealmNames().iterator()).hasNext()) {
            primaryRealmName = (String)itr.next();
            for (UserManager userManager : this.userManagers) {
                if (!primaryRealmName.equals(userManager.getAuthenticationRealmName())) continue;
                return userManager;
            }
        }
        throw new NoSuchUserManagerException("No UserManager for realm: " + primaryRealmName);
    }
}

