/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.events.AbstractEvent;
import org.sonatype.nexus.events.Event;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventRemove;
import org.sonatype.nexus.proxy.events.RepositoryRegistryRepositoryEvent;
import org.sonatype.nexus.proxy.events.TargetRegistryEvent;
import org.sonatype.nexus.proxy.events.TargetRegistryEventRemove;
import org.sonatype.security.SecuritySystem;
import org.sonatype.security.authorization.NoSuchAuthorizationManagerException;
import org.sonatype.security.authorization.NoSuchPrivilegeException;
import org.sonatype.security.authorization.Privilege;
import org.sonatype.security.realms.tools.ConfigurationManager;
import org.sonatype.security.realms.tools.ConfigurationManagerAction;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class SecurityCleanupEventInspector
extends ComponentSupport
implements EventSubscriber {
    private final ConfigurationManager configManager;
    private final SecuritySystem security;

    @Inject
    public SecurityCleanupEventInspector(ConfigurationManager configManager, SecuritySystem security) {
        this.configManager = (ConfigurationManager)Preconditions.checkNotNull((Object)configManager);
        this.security = (SecuritySystem)Preconditions.checkNotNull((Object)security);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryRegistryEventRemove e) {
        this.inspect(e);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(TargetRegistryEventRemove e) {
        this.inspect(e);
    }

    protected void inspect(Event<?> evt) {
        AbstractEvent rEvt;
        if (evt instanceof RepositoryRegistryEventRemove) {
            rEvt = (RepositoryRegistryEventRemove)evt;
            String repositoryId = ((RepositoryRegistryRepositoryEvent)rEvt).getRepository().getId();
            try {
                this.cleanupPrivileges("repositoryId", repositoryId);
                this.cleanupPrivileges("repositoryGroupId", repositoryId);
            }
            catch (NoSuchPrivilegeException e) {
                this.log.error("Unable to clean privileges attached to repository", (Throwable)e);
            }
            catch (NoSuchAuthorizationManagerException e) {
                this.log.error("Unable to clean privileges attached to repository", (Throwable)e);
            }
        }
        if (evt instanceof TargetRegistryEventRemove) {
            rEvt = (TargetRegistryEventRemove)evt;
            String targetId = ((TargetRegistryEvent)rEvt).getTarget().getId();
            try {
                this.cleanupPrivileges("repositoryTargetId", targetId);
            }
            catch (NoSuchPrivilegeException e) {
                this.log.error("Unable to clean privileges attached to target: {}", (Object)targetId, (Object)e);
            }
            catch (NoSuchAuthorizationManagerException e) {
                this.log.error("Unable to clean privileges attached to target: {}", (Object)targetId, (Object)e);
            }
        }
    }

    protected void cleanupPrivileges(String propertyId, String propertyValue) throws NoSuchPrivilegeException, NoSuchAuthorizationManagerException {
        Set privileges = this.security.listPrivileges();
        final HashSet<String> removedIds = new HashSet<String>();
        for (Privilege privilege : privileges) {
            if (privilege.isReadOnly() || !privilege.getType().equals("target") || !propertyValue.equals(privilege.getPrivilegeProperty(propertyId))) continue;
            this.log.debug("Removing Privilege {} because repository was removed", (Object)privilege.getName());
            this.security.getAuthorizationManager("default").deletePrivilege(privilege.getId());
            removedIds.add(privilege.getId());
        }
        try {
            this.configManager.runWrite(new ConfigurationManagerAction(){

                public void run() throws Exception {
                    for (String privilegeId : removedIds) {
                        SecurityCleanupEventInspector.this.configManager.cleanRemovedPrivilege(privilegeId);
                    }
                    SecurityCleanupEventInspector.this.configManager.save();
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

