/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.security.model.CPrivilege;
import org.sonatype.security.realms.privileges.AbstractPrivilegeDescriptor;
import org.sonatype.security.realms.privileges.PrivilegeDescriptor;
import org.sonatype.security.realms.privileges.PrivilegePropertyDescriptor;
import org.sonatype.security.realms.validator.SecurityValidationContext;

@Singleton
@Named(value="RepositoryViewPrivilegeDescriptor")
public class RepositoryViewPrivilegeDescriptor
extends AbstractPrivilegeDescriptor
implements PrivilegeDescriptor {
    public static final String TYPE = "repository";
    private final PrivilegePropertyDescriptor repoProperty;

    @Inject
    public RepositoryViewPrivilegeDescriptor(@Named(value="RepositoryPropertyDescriptor") PrivilegePropertyDescriptor repoProperty) {
        this.repoProperty = (PrivilegePropertyDescriptor)Preconditions.checkNotNull((Object)repoProperty);
    }

    public String getName() {
        return "Repository View";
    }

    public List<PrivilegePropertyDescriptor> getPropertyDescriptors() {
        ArrayList<PrivilegePropertyDescriptor> propertyDescriptors = new ArrayList<PrivilegePropertyDescriptor>();
        propertyDescriptors.add(this.repoProperty);
        return propertyDescriptors;
    }

    public String getType() {
        return TYPE;
    }

    public String buildPermission(CPrivilege privilege) {
        if (!TYPE.equals(privilege.getType())) {
            return null;
        }
        String repoId = this.getProperty(privilege, "repositoryId");
        if (StringUtils.isEmpty((String)repoId)) {
            repoId = "*";
        }
        return RepositoryViewPrivilegeDescriptor.buildPermission(TYPE, repoId);
    }

    public ValidationResponse validatePrivilege(CPrivilege privilege, SecurityValidationContext ctx, boolean update) {
        ValidationResponse response = super.validatePrivilege(privilege, ctx, update);
        if (!TYPE.equals(privilege.getType())) {
            return response;
        }
        return response;
    }

    public static String buildPermission(String objectType, String objectId) {
        return "nexus:view:" + objectType + ":" + objectId;
    }
}

