/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventAdd;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventRemove;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.registry.RepositoryTypeRegistry;
import org.sonatype.nexus.proxy.registry.RootContentClass;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.security.model.CPrivilege;
import org.sonatype.security.model.CProperty;
import org.sonatype.security.model.CRole;
import org.sonatype.security.model.Configuration;
import org.sonatype.security.realms.tools.AbstractDynamicSecurityResource;
import org.sonatype.security.realms.tools.ConfigurationManager;
import org.sonatype.security.realms.tools.ConfigurationManagerAction;
import org.sonatype.security.realms.tools.DynamicSecurityResource;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Named(value="NexusViewSecurityResource")
public class NexusViewSecurityResource
extends AbstractDynamicSecurityResource
implements DynamicSecurityResource {
    private final RepositoryRegistry repoRegistry;
    private final RepositoryTypeRegistry repoTypeRegistry;
    private final ConfigurationManager configManager;

    @Inject
    public NexusViewSecurityResource(EventBus eventBus, RepositoryRegistry repoRegistry, RepositoryTypeRegistry repoTypeRegistry, @Named(value="default") ConfigurationManager configManager) {
        this.repoRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repoRegistry);
        this.repoTypeRegistry = (RepositoryTypeRegistry)Preconditions.checkNotNull((Object)repoTypeRegistry);
        this.configManager = (ConfigurationManager)Preconditions.checkNotNull((Object)configManager);
        eventBus.register((Object)this);
    }

    public Configuration doGetConfiguration() {
        Configuration configuration = new Configuration();
        configuration.addPrivilege(this.buildPrivilege("All Repositories - (view)", "Privilege that gives view access to all repositories.", "*"));
        for (Repository repo : this.repoRegistry.getRepositories()) {
            configuration.addPrivilege(this.buildPrivilege(repo.getName() + " - (view)", "Privilege that gives view access to the " + repo.getName() + " repository.", repo.getId()));
        }
        Set<Map.Entry<String, ContentClass>> contents = this.repoTypeRegistry.getContentClasses().entrySet();
        for (Map.Entry<String, ContentClass> entry : contents) {
            configuration.addRole(this.buildRole(entry, "view"));
        }
        this.setDirty(false);
        return configuration;
    }

    private CRole buildRole(Map.Entry<String, ContentClass> entry, String method) {
        String content = entry.getKey();
        CRole view = new CRole();
        view.setId(content + "-all-" + method);
        String contentClassName = entry.getValue().getName();
        if (entry.getValue() instanceof RootContentClass) {
            contentClassName = "";
        }
        view.setDescription("Gives access to " + method + " ALL " + contentClassName + " Repositories in Nexus.");
        method = StringUtils.capitalizeFirstLetter((String)method);
        view.setName("Repo: All " + contentClassName + " Repositories (" + method + ")");
        view.setSessionTimeout(60);
        List<? extends Repository> repos = this.getRepositoriesWithContentClass(entry.getValue());
        for (Repository repository : repos) {
            view.addPrivilege("repository-" + repository.getId());
        }
        return view;
    }

    private List<? extends Repository> getRepositoriesWithContentClass(ContentClass content) {
        ArrayList<Repository> filtered = new ArrayList<Repository>();
        List<Repository> repos = this.repoRegistry.getRepositories();
        for (Repository repository : repos) {
            if (!content.equals(repository.getRepositoryContentClass())) continue;
            filtered.add(repository);
        }
        return filtered;
    }

    protected CPrivilege buildPrivilege(String name, String description, String repoId) {
        CPrivilege priv = new CPrivilege();
        priv.setId(this.createPrivilegeId(repoId));
        priv.setName(name);
        priv.setDescription(description);
        priv.setType("repository");
        CProperty prop = new CProperty();
        prop.setKey("repositoryId");
        prop.setValue(repoId);
        priv.addProperty(prop);
        return priv;
    }

    private String createPrivilegeId(String repoId) {
        return "repository-" + (repoId.equals("*") ? "all" : repoId);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onEvent(RepositoryRegistryEventAdd event) {
        this.setDirty(true);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onEvent(final RepositoryRegistryEventRemove event) {
        this.setDirty(true);
        try {
            this.configManager.runWrite(new ConfigurationManagerAction(){

                public void run() throws Exception {
                    NexusViewSecurityResource.this.configManager.cleanRemovedPrivilege(NexusViewSecurityResource.this.createPrivilegeId(event.getRepository().getId()));
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

