/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.email.NexusPostOffice;
import org.sonatype.nexus.events.Asynchronous;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.scheduling.NexusTask;
import org.sonatype.nexus.scheduling.events.NexusTaskEventStoppedFailed;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class NexusTaskFailureAlertEmailSender
extends ComponentSupport
implements EventSubscriber,
Asynchronous {
    private final NexusPostOffice m_postOffice;

    @Inject
    public NexusTaskFailureAlertEmailSender(NexusPostOffice m_postOffice) {
        this.m_postOffice = (NexusPostOffice)Preconditions.checkNotNull((Object)m_postOffice);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void inspect(NexusTaskEventStoppedFailed<?> failureEvent) {
        NexusTask failedTask = failureEvent.getNexusTask();
        if (failedTask == null || !failedTask.shouldSendAlertEmail()) {
            return;
        }
        this.m_postOffice.sendNexusTaskFailure(failedTask.getAlertEmail(), failedTask.getId(), failedTask.getName(), failureEvent.getFailureCause());
    }
}

