/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.AbstractLastingConfigurable;
import org.sonatype.nexus.configuration.CoreConfiguration;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.application.NexusConfiguration;
import org.sonatype.nexus.configuration.model.CProps;
import org.sonatype.nexus.configuration.model.CScheduleConfig;
import org.sonatype.nexus.configuration.model.CScheduledTask;
import org.sonatype.nexus.configuration.model.CScheduledTaskCoreConfiguration;
import org.sonatype.nexus.scheduling.TaskUtils;
import org.sonatype.scheduling.DefaultScheduledTask;
import org.sonatype.scheduling.ScheduledTask;
import org.sonatype.scheduling.Scheduler;
import org.sonatype.scheduling.SchedulerTask;
import org.sonatype.scheduling.TaskConfigManager;
import org.sonatype.scheduling.schedules.CronSchedule;
import org.sonatype.scheduling.schedules.DailySchedule;
import org.sonatype.scheduling.schedules.HourlySchedule;
import org.sonatype.scheduling.schedules.ManualRunSchedule;
import org.sonatype.scheduling.schedules.MonthlySchedule;
import org.sonatype.scheduling.schedules.OnceSchedule;
import org.sonatype.scheduling.schedules.RunNowSchedule;
import org.sonatype.scheduling.schedules.Schedule;
import org.sonatype.scheduling.schedules.WeeklySchedule;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Named
public class DefaultTaskConfigManager
extends AbstractLastingConfigurable<List<CScheduledTask>>
implements TaskConfigManager {
    private final Map<String, Provider<SchedulerTask<?>>> tasks;

    @Inject
    public DefaultTaskConfigManager(EventBus eventBus, NexusConfiguration nexusConfiguration, Map<String, Provider<SchedulerTask<?>>> tasks) {
        super("Scheduled Tasks", eventBus, nexusConfiguration);
        this.tasks = (Map)Preconditions.checkNotNull(tasks);
    }

    @Override
    public void initializeConfiguration() throws ConfigurationException {
        if (this.getApplicationConfiguration() != null && this.getApplicationConfiguration().getConfigurationModel() != null) {
            this.configure(this.getApplicationConfiguration());
        }
    }

    @Override
    protected CoreConfiguration<List<CScheduledTask>> wrapConfiguration(Object configuration) throws ConfigurationException {
        if (configuration instanceof ApplicationConfiguration) {
            return new CScheduledTaskCoreConfiguration((ApplicationConfiguration)configuration);
        }
        throw new ConfigurationException("The passed configuration object is of class \"" + configuration.getClass().getName() + "\" and not the required \"" + ApplicationConfiguration.class.getName() + "\"!");
    }

    public void initializeTasks(Scheduler scheduler) {
        this.initializeTasks(scheduler, new ArrayList<CScheduledTask>((Collection)this.getCurrentConfiguration(false)));
    }

    void initializeTasks(Scheduler scheduler, List<CScheduledTask> tasks) {
        if (tasks != null) {
            ArrayList<CScheduledTask> tempList = new ArrayList<CScheduledTask>(tasks);
            this.log.info(tempList.size() + " task(s) to load.");
            for (CScheduledTask task : tempList) {
                this.log.info("Loading task - " + task.getName());
                try {
                    SchedulerTask<?> nexusTask = this.createTaskInstance(task.getType());
                    for (CProps prop : task.getProperties()) {
                        nexusTask.addParameter(prop.getKey(), prop.getValue());
                    }
                    TaskUtils.setId(nexusTask, task.getId());
                    TaskUtils.setName(nexusTask, task.getName());
                    DefaultScheduledTask scheduledTask = (DefaultScheduledTask)scheduler.initialize(task.getId(), task.getName(), task.getType(), nexusTask, this.translateFrom(task.getSchedule(), new Date(task.getNextRun())), task.isEnabled());
                    if (task.getLastRun() <= 0L) continue;
                    scheduledTask.setLastRun(new Date(task.getLastRun()));
                }
                catch (IllegalArgumentException e) {
                    this.log.warn("Unable to initialize task " + task.getName() + ", couldn't load service class " + task.getId(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addTask(ScheduledTask<T> task) {
        if (RunNowSchedule.class.isAssignableFrom(task.getSchedule().getClass())) {
            return;
        }
        ApplicationConfiguration applicationConfiguration = this.getApplicationConfiguration();
        synchronized (applicationConfiguration) {
            List tasks = (List)this.getCurrentConfiguration(true);
            CScheduledTask foundTask = this.findTask(task.getId(), tasks);
            CScheduledTask storeableTask = this.translateFrom(task);
            if (storeableTask != null) {
                if (foundTask != null) {
                    tasks.remove(foundTask);
                    storeableTask.setLastRun(foundTask.getLastRun());
                }
                tasks.add(storeableTask);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Task with ID={} added, config {} modified.", new Object[]{task.getId(), storeableTask != null ? "IS" : "is NOT", new Exception("This is an exception only to provide caller backtrace")});
            }
            try {
                this.getApplicationConfiguration().saveConfiguration();
            }
            catch (IOException e) {
                this.log.warn("Could not save task changes!", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void removeTask(ScheduledTask<T> task) {
        ApplicationConfiguration applicationConfiguration = this.getApplicationConfiguration();
        synchronized (applicationConfiguration) {
            List tasks = (List)this.getCurrentConfiguration(true);
            CScheduledTask foundTask = this.findTask(task.getId(), tasks);
            if (foundTask != null) {
                tasks.remove(foundTask);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Task with ID={} removed, config {} modified.", new Object[]{task.getId(), foundTask != null ? "IS" : "is NOT", new Exception("This is an exception only to provide caller backtrace")});
            }
            try {
                this.getApplicationConfiguration().saveConfiguration();
            }
            catch (IOException e) {
                this.log.warn("Could not save task changes!", (Throwable)e);
            }
        }
    }

    public SchedulerTask<?> createTaskInstance(String taskType) throws IllegalArgumentException {
        return this.lookupTask(taskType);
    }

    private SchedulerTask<?> lookupTask(String taskType) {
        this.log.debug("Looking up task for: " + taskType);
        Provider<SchedulerTask<?>> taskProvider = this.tasks.get(taskType);
        if (taskProvider == null) {
            throw new IllegalArgumentException("Could not find task of type: " + taskType);
        }
        return (SchedulerTask)taskProvider.get();
    }

    public <T> T createTaskInstance(Class<T> taskType) throws IllegalArgumentException {
        this.log.debug("Creating task: {}", taskType);
        try {
            return (T)this.lookupTask(taskType.getCanonicalName());
        }
        catch (IllegalArgumentException e) {
            return (T)this.lookupTask(taskType.getSimpleName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CScheduledTask findTask(String id, List<CScheduledTask> tasks) {
        ApplicationConfiguration applicationConfiguration = this.getApplicationConfiguration();
        synchronized (applicationConfiguration) {
            for (CScheduledTask storedTask : tasks) {
                if (!storedTask.getId().equals(id)) continue;
                return storedTask;
            }
            return null;
        }
    }

    private Schedule translateFrom(CScheduleConfig modelSchedule, Date nextRun) {
        HashSet<Integer> daysToRun;
        CronSchedule schedule = null;
        Date startDate = null;
        Date endDate = null;
        if (modelSchedule.getStartDate() > 0L) {
            startDate = new Date(modelSchedule.getStartDate());
        }
        if (modelSchedule.getEndDate() > 0L) {
            endDate = new Date(modelSchedule.getEndDate());
        }
        if ("advanced".equals(modelSchedule.getType())) {
            try {
                schedule = new CronSchedule(modelSchedule.getCronCommand());
            }
            catch (ParseException parseException) {}
        } else if ("monthly".equals(modelSchedule.getType())) {
            daysToRun = new HashSet<Integer>();
            for (String day : modelSchedule.getDaysOfMonth()) {
                try {
                    daysToRun.add(Integer.valueOf(day));
                }
                catch (NumberFormatException nfe) {
                    this.log.error("Invalid day being added to monthly schedule - " + day + " - skipping.");
                }
            }
            schedule = new MonthlySchedule(startDate, endDate, daysToRun);
        } else if ("weekly".equals(modelSchedule.getType())) {
            daysToRun = new HashSet();
            for (String day : modelSchedule.getDaysOfWeek()) {
                try {
                    daysToRun.add(Integer.valueOf(day));
                }
                catch (NumberFormatException nfe) {
                    this.log.error("Invalid day being added to weekly schedule - " + day + " - skipping.");
                }
            }
            schedule = new WeeklySchedule(startDate, endDate, daysToRun);
        } else if ("daily".equals(modelSchedule.getType())) {
            schedule = new DailySchedule(startDate, endDate);
        } else if ("hourly".equals(modelSchedule.getType())) {
            schedule = new HourlySchedule(startDate, endDate);
        } else if ("once".equals(modelSchedule.getType())) {
            schedule = new OnceSchedule(startDate);
        } else if ("runNow".equals(modelSchedule.getType())) {
            schedule = new RunNowSchedule();
        } else if ("manual".equals(modelSchedule.getType())) {
            schedule = new ManualRunSchedule();
        } else {
            throw new IllegalArgumentException("Unknown Schedule type: " + modelSchedule.getClass().getName());
        }
        if (nextRun != null) {
            Date resetFrom = nextRun;
            if (schedule instanceof CronSchedule) {
                resetFrom = new Date(resetFrom.getTime() - 1000L);
            }
            schedule.getIterator().resetFrom(resetFrom);
        }
        return schedule;
    }

    private <T> CScheduledTask translateFrom(ScheduledTask<T> task) {
        CScheduledTask storeableTask = new CScheduledTask();
        storeableTask.setEnabled(task.isEnabled());
        storeableTask.setId(task.getId());
        storeableTask.setName(task.getName());
        storeableTask.setType(task.getType());
        storeableTask.setStatus(task.getTaskState().name());
        if (task.getLastRun() != null) {
            storeableTask.setLastRun(task.getLastRun().getTime());
        }
        if (task.getNextRun() != null) {
            storeableTask.setNextRun(task.getNextRun().getTime());
        }
        for (String key : task.getTaskParams().keySet()) {
            CProps props = new CProps();
            props.setKey(key);
            props.setValue((String)task.getTaskParams().get(key));
            storeableTask.addProperty(props);
        }
        Schedule schedule = task.getSchedule();
        CScheduleConfig storeableSchedule = new CScheduleConfig();
        if (schedule != null) {
            Date endDate;
            if (CronSchedule.class.isAssignableFrom(schedule.getClass())) {
                storeableSchedule.setType("advanced");
                storeableSchedule.setCronCommand(((CronSchedule)schedule).getCronString());
            } else if (MonthlySchedule.class.isAssignableFrom(schedule.getClass())) {
                storeableSchedule.setType("monthly");
                storeableSchedule.setStartDate(((MonthlySchedule)schedule).getStartDate().getTime());
                endDate = ((MonthlySchedule)schedule).getEndDate();
                if (endDate != null) {
                    storeableSchedule.setEndDate(endDate.getTime());
                }
                Iterator iter = ((MonthlySchedule)schedule).getDaysToRun().iterator();
                while (iter.hasNext()) {
                    storeableSchedule.addDaysOfMonth(String.valueOf(iter.next()));
                }
            } else if (WeeklySchedule.class.isAssignableFrom(schedule.getClass())) {
                storeableSchedule.setType("weekly");
                storeableSchedule.setStartDate(((WeeklySchedule)schedule).getStartDate().getTime());
                endDate = ((WeeklySchedule)schedule).getEndDate();
                if (endDate != null) {
                    storeableSchedule.setEndDate(endDate.getTime());
                }
                Iterator iter = ((WeeklySchedule)schedule).getDaysToRun().iterator();
                while (iter.hasNext()) {
                    storeableSchedule.addDaysOfWeek(String.valueOf(iter.next()));
                }
            } else if (DailySchedule.class.isAssignableFrom(schedule.getClass())) {
                storeableSchedule.setType("daily");
                storeableSchedule.setStartDate(((DailySchedule)schedule).getStartDate().getTime());
                endDate = ((DailySchedule)schedule).getEndDate();
                if (endDate != null) {
                    storeableSchedule.setEndDate(endDate.getTime());
                }
            } else if (HourlySchedule.class.isAssignableFrom(schedule.getClass())) {
                storeableSchedule.setType("hourly");
                storeableSchedule.setStartDate(((HourlySchedule)schedule).getStartDate().getTime());
                endDate = ((HourlySchedule)schedule).getEndDate();
                if (endDate != null) {
                    storeableSchedule.setEndDate(endDate.getTime());
                }
            } else if (OnceSchedule.class.isAssignableFrom(schedule.getClass())) {
                storeableSchedule.setType("once");
                storeableSchedule.setStartDate(((OnceSchedule)schedule).getStartDate().getTime());
            } else if (RunNowSchedule.class.isAssignableFrom(schedule.getClass())) {
                storeableSchedule.setType("runNow");
            } else if (ManualRunSchedule.class.isAssignableFrom(schedule.getClass())) {
                storeableSchedule.setType("manual");
            } else {
                throw new IllegalArgumentException("Unknown Schedule type: " + schedule.getClass().getName());
            }
        }
        storeableTask.setSchedule(storeableSchedule);
        return storeableTask;
    }
}

