/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.scheduling.NexusScheduler;
import org.sonatype.nexus.scheduling.NexusTask;
import org.sonatype.scheduling.NoSuchTaskException;
import org.sonatype.scheduling.ScheduledTask;
import org.sonatype.scheduling.Scheduler;
import org.sonatype.scheduling.schedules.Schedule;

@Named
@Singleton
public class DefaultNexusScheduler
implements NexusScheduler {
    private final Scheduler scheduler;

    @Inject
    public DefaultNexusScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void initializeTasks() {
        this.scheduler.initializeTasks();
    }

    @Override
    public void shutdown() {
        this.scheduler.shutdown();
    }

    @Override
    public <T> ScheduledTask<T> submit(String name, NexusTask<T> nexusTask) throws RejectedExecutionException, NullPointerException {
        if (nexusTask.allowConcurrentSubmission(this.scheduler.getActiveTasks())) {
            return this.scheduler.submit(name, nexusTask);
        }
        throw new RejectedExecutionException("Task of this type is already submitted!");
    }

    @Override
    public <T> ScheduledTask<T> schedule(String name, NexusTask<T> nexusTask, Schedule schedule) throws RejectedExecutionException, NullPointerException {
        if (nexusTask.allowConcurrentSubmission(this.scheduler.getActiveTasks())) {
            return this.scheduler.schedule(name, nexusTask, schedule);
        }
        throw new RejectedExecutionException("Task of this type is already scheduled!");
    }

    @Override
    public <T> ScheduledTask<T> updateSchedule(ScheduledTask<T> task) throws RejectedExecutionException, NullPointerException {
        if (task != null) {
            this.scheduler.updateSchedule(task);
        }
        return task;
    }

    @Override
    public Map<String, List<ScheduledTask<?>>> getAllTasks() {
        return this.scheduler.getAllTasks();
    }

    @Override
    public Map<String, List<ScheduledTask<?>>> getActiveTasks() {
        return this.scheduler.getActiveTasks();
    }

    @Override
    public ScheduledTask<?> getTaskById(String id) throws NoSuchTaskException {
        return this.scheduler.getTaskById(id);
    }

    @Override
    @Deprecated
    public NexusTask<?> createTaskInstance(String taskType) throws IllegalArgumentException {
        return (NexusTask)this.scheduler.createTaskInstance(taskType);
    }

    @Override
    public <T> T createTaskInstance(Class<T> taskType) throws IllegalArgumentException {
        return (T)this.scheduler.createTaskInstance(taskType);
    }
}

