/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling;

import org.sonatype.scheduling.ScheduledTask;
import org.sonatype.scheduling.SchedulerTask;

public class TaskUtils {
    private TaskUtils() {
    }

    public static boolean isPrivateProperty(String key) {
        return key != null && key.startsWith(".");
    }

    public static String getAlertEmail(ScheduledTask<?> task) {
        if (task != null && task.getTaskParams() != null) {
            return (String)task.getTaskParams().get(".alertEmail");
        }
        return null;
    }

    public static void setAlertEmail(ScheduledTask<?> task, String alertEmail) {
        if (task != null && task.getTaskParams() != null) {
            if (alertEmail != null) {
                task.getTaskParams().put(".alertEmail", alertEmail);
            } else {
                task.getTaskParams().remove(".alertEmail");
            }
        }
    }

    public static void setAlertEmail(SchedulerTask<?> task, String email) {
        if (email == null || email.trim().length() == 0) {
            task.getParameters().remove(".alertEmail");
        } else {
            task.addParameter(".alertEmail", email);
        }
    }

    public static void setId(ScheduledTask<?> task, String id) {
        if (id == null || id.trim().length() == 0) {
            task.getTaskParams().remove(".id");
        } else {
            task.getTaskParams().put(".id", id);
        }
    }

    public static void setId(SchedulerTask<?> task, String id) {
        if (id == null || id.trim().length() == 0) {
            task.getParameters().remove(".id");
        } else {
            task.addParameter(".id", id);
        }
    }

    public static void setName(ScheduledTask<?> task, String name) {
        if (name == null || name.trim().length() == 0) {
            task.getTaskParams().remove(".name");
        } else {
            task.getTaskParams().put(".name", name);
        }
    }

    public static void setName(SchedulerTask<?> task, String name) {
        if (name == null || name.trim().length() == 0) {
            task.getParameters().remove(".name");
        } else {
            task.addParameter(".name", name);
        }
    }
}

